/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util;

import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CodeGenerationUtil {
    private static final PrimitiveWrapperConverter C_BYTE = new PrimitiveWrapperConverter(ConstantDescs.CD_Byte, ConstantDescs.CD_byte);
    private static final PrimitiveWrapperConverter C_SHORT = new PrimitiveWrapperConverter(ConstantDescs.CD_Short, ConstantDescs.CD_short);
    private static final PrimitiveWrapperConverter C_INT = new PrimitiveWrapperConverter(ConstantDescs.CD_Integer, ConstantDescs.CD_int);
    private static final PrimitiveWrapperConverter C_LONG = new PrimitiveWrapperConverter(ConstantDescs.CD_Long, ConstantDescs.CD_long);
    private static final PrimitiveWrapperConverter C_FLOAT = new PrimitiveWrapperConverter(ConstantDescs.CD_Float, ConstantDescs.CD_float);
    private static final PrimitiveWrapperConverter C_DOUBLE = new PrimitiveWrapperConverter(ConstantDescs.CD_Double, ConstantDescs.CD_double);
    private static final PrimitiveWrapperConverter C_CHAR = new PrimitiveWrapperConverter(ConstantDescs.CD_Character, ConstantDescs.CD_char);
    private static final PrimitiveWrapperConverter C_BOOL = new PrimitiveWrapperConverter(ConstantDescs.CD_Boolean, ConstantDescs.CD_boolean);
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;
    private static final MethodHandles.Lookup.ClassOption[] NEST_MATE_DEFINE_OPTIONS;

    private CodeGenerationUtil() {
        throw new UnsupportedOperationException();
    }

    public static void unboxPrimitive(@NonNull CodeBuilder codeBuilder, @NonNull String targetDescriptor) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (targetDescriptor == null) {
            throw new NullPointerException("targetDescriptor is marked non-null but is null");
        }
        switch (targetDescriptor) {
            case "B": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_BYTE);
                break;
            }
            case "S": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_SHORT);
                break;
            }
            case "I": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_INT);
                break;
            }
            case "J": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_LONG);
                break;
            }
            case "F": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_FLOAT);
                break;
            }
            case "D": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_DOUBLE);
                break;
            }
            case "C": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_CHAR);
                break;
            }
            case "Z": {
                CodeGenerationUtil.unboxPrimitive(codeBuilder, C_BOOL);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid primitive type: " + targetDescriptor);
            }
        }
    }

    private static void unboxPrimitive(@NonNull CodeBuilder codeBuilder, @NonNull PrimitiveWrapperConverter converter) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        codeBuilder.checkcast(converter.wrapperType).invokevirtual(converter.wrapperType, converter.fromWrapperMethod, converter.fromWrapperDesc);
    }

    public static void boxPrimitive(@NonNull CodeBuilder codeBuilder, @NonNull String sourceDescriptor) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (sourceDescriptor == null) {
            throw new NullPointerException("sourceDescriptor is marked non-null but is null");
        }
        switch (sourceDescriptor) {
            case "B": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_BYTE);
                break;
            }
            case "S": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_SHORT);
                break;
            }
            case "I": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_INT);
                break;
            }
            case "J": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_LONG);
                break;
            }
            case "F": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_FLOAT);
                break;
            }
            case "D": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_DOUBLE);
                break;
            }
            case "C": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_CHAR);
                break;
            }
            case "Z": {
                CodeGenerationUtil.boxPrimitive(codeBuilder, C_BOOL);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid primitive type: " + sourceDescriptor);
            }
        }
    }

    private static void boxPrimitive(@NonNull CodeBuilder codeBuilder, @NonNull PrimitiveWrapperConverter converter) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        codeBuilder.invokestatic(converter.wrapperType, converter.toWrapperMethod, converter.toWrapperDesc);
    }

    @NonNull
    public static Class<?> defineClass(@NonNull Class<?> parentClass, byte[] classData) {
        if (parentClass == null) {
            throw new NullPointerException("parentClass is marked non-null but is null");
        }
        try {
            return TRUSTED_LOOKUP.in(parentClass).defineClass(classData);
        }
        catch (IllegalAccessException exception) {
            throw new AssertionError("trusted lookup had no permission to define class", exception);
        }
    }

    @NonNull
    public static MethodHandles.Lookup defineNestedClass(@NonNull Class<?> hostClass, byte[] classData) {
        if (hostClass == null) {
            throw new NullPointerException("hostClass is marked non-null but is null");
        }
        try {
            return TRUSTED_LOOKUP.in(hostClass).defineHiddenClass(classData, false, NEST_MATE_DEFINE_OPTIONS);
        }
        catch (IllegalAccessException exception) {
            throw new AssertionError("trusted lookup had no permission to define class", exception);
        }
    }

    static {
        NEST_MATE_DEFINE_OPTIONS = new MethodHandles.Lookup.ClassOption[]{MethodHandles.Lookup.ClassOption.NESTMATE};
        try {
            Field trustedLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            trustedLookupField.setAccessible(true);
            TRUSTED_LOOKUP = (MethodHandles.Lookup)trustedLookupField.get(null);
        }
        catch (ReflectiveOperationException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private record PrimitiveWrapperConverter(@NonNull ClassDesc wrapperType, @NonNull ClassDesc primitiveType, @NonNull String toWrapperMethod, @NonNull String fromWrapperMethod, @NonNull MethodTypeDesc toWrapperDesc, @NonNull MethodTypeDesc fromWrapperDesc) {
        @Generated
        public PrimitiveWrapperConverter(@NonNull ClassDesc wrapperType, @NonNull ClassDesc primitiveType, @NonNull String toWrapperMethod, @NonNull String fromWrapperMethod, @NonNull MethodTypeDesc toWrapperDesc, @NonNull MethodTypeDesc fromWrapperDesc) {
            if (wrapperType == null) {
                throw new NullPointerException("wrapperType is marked non-null but is null");
            }
            if (primitiveType == null) {
                throw new NullPointerException("primitiveType is marked non-null but is null");
            }
            if (toWrapperMethod == null) {
                throw new NullPointerException("toWrapperMethod is marked non-null but is null");
            }
            if (fromWrapperMethod == null) {
                throw new NullPointerException("fromWrapperMethod is marked non-null but is null");
            }
            if (toWrapperDesc == null) {
                throw new NullPointerException("toWrapperDesc is marked non-null but is null");
            }
            if (fromWrapperDesc == null) {
                throw new NullPointerException("fromWrapperDesc is marked non-null but is null");
            }
        }

        private PrimitiveWrapperConverter(@NonNull ClassDesc wrapperTypeDesc, @NonNull ClassDesc primitiveTypeDesc) {
            this(wrapperTypeDesc, primitiveTypeDesc, "valueOf", String.format("%sValue", primitiveTypeDesc.displayName()), MethodTypeDesc.of(wrapperTypeDesc, primitiveTypeDesc), MethodTypeDesc.of(primitiveTypeDesc));
            if (wrapperTypeDesc == null) {
                throw new NullPointerException("wrapperTypeDesc is marked non-null but is null");
            }
            if (primitiveTypeDesc == null) {
                throw new NullPointerException("primitiveTypeDesc is marked non-null but is null");
            }
        }
    }
}

