/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import sun.misc.Unsafe;

@ApiStatus.Internal
public final class ClassAllocationUtil {
    private static final MethodType NO_ARGS_CONSTRUCTOR_TYPE;
    private static final MethodType SUPPLIER_GET_SIGNATURE;
    private static final MethodType SUPPLIER_FACTORY_SIGNATURE;
    private static final Function<Class<?>, Supplier<Object>> LOOKUP_ALLOCATOR;
    private static final Function<Class<?>, Supplier<Object>> UNSAFE_ALLOCATOR;

    private ClassAllocationUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    private static Object getInaccessibleFieldValue(@NonNull Field field) throws IllegalAccessException {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        field.setAccessible(true);
        return field.get(null);
    }

    @NonNull
    private static Function<Class<?>, Supplier<Object>> makeLookupAlloc(@NonNull MethodHandles.Lookup lookup) {
        if (lookup == null) {
            throw new NullPointerException("lookup is marked non-null but is null");
        }
        return targetClass -> {
            try {
                MethodHandles.Lookup targetClassLookup = lookup.in((Class<?>)targetClass);
                MethodHandle noArgsConstructor = targetClassLookup.findConstructor((Class<?>)targetClass, NO_ARGS_CONSTRUCTOR_TYPE);
                CallSite callSite = LambdaMetafactory.metafactory(targetClassLookup, "get", SUPPLIER_FACTORY_SIGNATURE, SUPPLIER_GET_SIGNATURE, noArgsConstructor, SUPPLIER_FACTORY_SIGNATURE);
                return callSite.getTarget().invokeExact();
            }
            catch (NoSuchMethodException targetClassLookup) {
                return null;
            }
            catch (Throwable throwable) {
                throw new AssertionError("unable to construct supplier factory", throwable);
            }
        };
    }

    @NonNull
    private static Function<Class<?>, Supplier<Object>> makeUnsafeAlloc(@NonNull Object theUnsafe) {
        if (theUnsafe == null) {
            throw new NullPointerException("theUnsafe is marked non-null but is null");
        }
        return targetClass -> () -> {
            try {
                Unsafe unsafe = (Unsafe)theUnsafe;
                return unsafe.allocateInstance((Class<?>)targetClass);
            }
            catch (InstantiationException exception) {
                throw new IllegalStateException("unable to allocate instance class", exception);
            }
        };
    }

    @NonNull
    public static Supplier<Object> makeInstanceFactory(@NonNull Class<?> targetClass) {
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        Supplier<Object> lookupAllocator = LOOKUP_ALLOCATOR.apply(targetClass);
        if (lookupAllocator != null) {
            return lookupAllocator;
        }
        if (UNSAFE_ALLOCATOR != null) {
            return UNSAFE_ALLOCATOR.apply(targetClass);
        }
        throw new IllegalStateException(String.format("unable to create instance factory for %s", targetClass.getName()));
    }

    static {
        Function<Class<?>, Supplier<Object>> unsafeAllocator;
        NO_ARGS_CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE);
        SUPPLIER_GET_SIGNATURE = MethodType.methodType(Object.class);
        SUPPLIER_FACTORY_SIGNATURE = MethodType.methodType(Supplier.class);
        try {
            Field trustedLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.Lookup trustedLookup = (MethodHandles.Lookup)ClassAllocationUtil.getInaccessibleFieldValue(trustedLookupField);
            LOOKUP_ALLOCATOR = ClassAllocationUtil.makeLookupAlloc(trustedLookup);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            Object theUnsafe = ClassAllocationUtil.getInaccessibleFieldValue(unsafeField);
            unsafeAllocator = ClassAllocationUtil.makeUnsafeAlloc(theUnsafe);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            unsafeAllocator = null;
        }
        UNSAFE_ALLOCATOR = unsafeAllocator;
    }
}

