/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.template;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import eu.cloudnetservice.driver.template.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public interface TemplateStorage
extends AutoCloseable,
Named {
    default public boolean deployDirectory(@NonNull ServiceTemplate target, @NonNull Path directory) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return this.deployDirectory(target, directory, null);
    }

    public boolean deployDirectory(@NonNull ServiceTemplate var1, @NonNull Path var2, @Nullable Predicate<Path> var3);

    public boolean deploy(@NonNull ServiceTemplate var1, @NonNull InputStream var2);

    public boolean pull(@NonNull ServiceTemplate var1, @NonNull Path var2);

    @Nullable
    public InputStream zipTemplate(@NonNull ServiceTemplate var1) throws IOException;

    @Nullable
    default public ZipInputStream openZipInputStream(@NonNull ServiceTemplate template) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        InputStream inputStream = this.zipTemplate(template);
        return inputStream == null ? null : new ZipInputStream(inputStream);
    }

    public boolean delete(@NonNull ServiceTemplate var1);

    public boolean create(@NonNull ServiceTemplate var1);

    public boolean contains(@NonNull ServiceTemplate var1);

    @Nullable
    public OutputStream appendOutputStream(@NonNull ServiceTemplate var1, @NonNull String var2) throws IOException;

    @Nullable
    public OutputStream newOutputStream(@NonNull ServiceTemplate var1, @NonNull String var2) throws IOException;

    public boolean createFile(@NonNull ServiceTemplate var1, @NonNull String var2);

    public boolean createDirectory(@NonNull ServiceTemplate var1, @NonNull String var2);

    public boolean hasFile(@NonNull ServiceTemplate var1, @NonNull String var2);

    public boolean deleteFile(@NonNull ServiceTemplate var1, @NonNull String var2);

    @Nullable
    public InputStream newInputStream(@NonNull ServiceTemplate var1, @NonNull String var2) throws IOException;

    @Nullable
    public FileInfo fileInfo(@NonNull ServiceTemplate var1, @NonNull String var2);

    @NonNull
    public Collection<FileInfo> listFiles(@NonNull ServiceTemplate var1, @NonNull String var2, boolean var3);

    @NonNull
    public Collection<ServiceTemplate> templates();

    @Override
    public void close() throws IOException;

    @NonNull
    default public CompletableFuture<Boolean> deployDirectoryAsync(@NonNull ServiceTemplate target, @NonNull Path directory) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return this.deployDirectoryAsync(target, directory, null);
    }

    @NonNull
    default public CompletableFuture<Boolean> deployDirectoryAsync(@NonNull ServiceTemplate target, @NonNull Path directory, @Nullable Predicate<Path> filter) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.deployDirectory(target, directory, filter));
    }

    @NonNull
    default public CompletableFuture<Boolean> deployAsync(@NonNull ServiceTemplate target, @NonNull InputStream inputStream) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.deploy(target, inputStream));
    }

    @NonNull
    default public CompletableFuture<Boolean> pullAsync(@NonNull ServiceTemplate template, @NonNull Path directory) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.pull(template, directory));
    }

    @NonNull
    default public CompletableFuture<InputStream> zipTemplateAsync(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.zipTemplate(template));
    }

    @NonNull
    default public CompletableFuture<ZipInputStream> openZipInputStreamAsync(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> {
            InputStream stream = this.zipTemplate(template);
            return stream == null ? null : new ZipInputStream(stream);
        });
    }

    @NonNull
    default public CompletableFuture<Boolean> deleteAsync(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.delete(template));
    }

    @NonNull
    default public CompletableFuture<Boolean> createAsync(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.create(template));
    }

    @NonNull
    default public CompletableFuture<Boolean> containsAsync(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.contains(template));
    }

    @NonNull
    default public CompletableFuture<OutputStream> appendOutputStreamAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.appendOutputStream(template, path));
    }

    @NonNull
    default public CompletableFuture<OutputStream> newOutputStreamAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.newOutputStream(template, path));
    }

    @NonNull
    default public CompletableFuture<Boolean> createFileAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.createFile(template, path));
    }

    @NonNull
    default public CompletableFuture<Boolean> createDirectoryAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.createDirectory(template, path));
    }

    @NonNull
    default public CompletableFuture<Boolean> hasFileAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.hasFile(template, path));
    }

    @NonNull
    default public CompletableFuture<Boolean> deleteFileAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.deleteFile(template, path));
    }

    @NonNull
    default public CompletableFuture<InputStream> newInputStreamAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.newInputStream(template, path));
    }

    @NonNull
    default public CompletableFuture<FileInfo> fileInfoAsync(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.fileInfo(template, path));
    }

    @NonNull
    default public CompletableFuture<Collection<FileInfo>> listFilesAsync(@NonNull ServiceTemplate template, @NonNull String dir, boolean deep) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.listFiles(template, dir, deep));
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceTemplate>> templatesAsync() {
        return TaskUtil.supplyAsync(this::templates);
    }

    @NonNull
    default public CompletableFuture<Void> closeAsync() {
        return TaskUtil.supplyAsync(() -> {
            this.close();
            return null;
        });
    }
}

