/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.service.ProcessConfiguration;
import eu.cloudnetservice.driver.service.ServiceConfigurationBase;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public class ServiceTask
extends ServiceConfigurationBase
implements Cloneable,
Named {
    public static final String NAMING_REGEX = "^[a-zA-Z\\d._\\-*]+$";
    public static final Pattern NAMING_PATTERN = Pattern.compile("^[a-zA-Z\\d._\\-*]+$");
    private final String name;
    private final String runtime;
    private final String hostAddress;
    private final String javaCommand;
    private final String nameSplitter;
    private final boolean disableIpRewrite;
    private final boolean maintenance;
    private final boolean autoDeleteOnStop;
    private final boolean staticServices;
    private final Set<String> groups;
    private final Set<String> associatedNodes;
    private final Set<String> deletedFilesAfterStop;
    private final ProcessConfiguration processConfiguration;
    private final int startPort;
    private final int minServiceCount;

    protected ServiceTask(@NonNull String name, @NonNull String runtime, @Nullable String hostAddress, @Nullable String javaCommand, @NonNull String nameSplitter, boolean disableIpRewrite, boolean maintenance, boolean autoDeleteOnStop, boolean staticServices, @NonNull Set<String> groups, @NonNull Set<String> associatedNodes, @NonNull Set<String> deletedFilesAfterStop, @NonNull ProcessConfiguration processConfiguration, int startPort, int minServiceCount, @NonNull Set<ServiceTemplate> templates, @NonNull Set<ServiceDeployment> deployments, @NonNull Set<ServiceRemoteInclusion> includes, @NonNull Document properties) {
        super(templates, deployments, includes, properties);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (runtime == null) {
            throw new NullPointerException("runtime is marked non-null but is null");
        }
        if (nameSplitter == null) {
            throw new NullPointerException("nameSplitter is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (associatedNodes == null) {
            throw new NullPointerException("associatedNodes is marked non-null but is null");
        }
        if (deletedFilesAfterStop == null) {
            throw new NullPointerException("deletedFilesAfterStop is marked non-null but is null");
        }
        if (processConfiguration == null) {
            throw new NullPointerException("processConfiguration is marked non-null but is null");
        }
        if (templates == null) {
            throw new NullPointerException("templates is marked non-null but is null");
        }
        if (deployments == null) {
            throw new NullPointerException("deployments is marked non-null but is null");
        }
        if (includes == null) {
            throw new NullPointerException("includes is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.runtime = runtime;
        this.hostAddress = hostAddress;
        this.javaCommand = javaCommand;
        this.nameSplitter = nameSplitter;
        this.disableIpRewrite = disableIpRewrite;
        this.maintenance = maintenance;
        this.autoDeleteOnStop = autoDeleteOnStop;
        this.staticServices = staticServices;
        this.associatedNodes = associatedNodes;
        this.groups = groups;
        this.deletedFilesAfterStop = deletedFilesAfterStop;
        this.processConfiguration = processConfiguration;
        this.startPort = startPort;
        this.minServiceCount = minServiceCount;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceTask serviceTask) {
        if (serviceTask == null) {
            throw new NullPointerException("serviceTask is marked non-null but is null");
        }
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ServiceTask.builder().name(serviceTask.name()).javaCommand(serviceTask.javaCommand()).runtime(serviceTask.runtime()).hostAddress(serviceTask.hostAddress()).nameSplitter(serviceTask.nameSplitter()).maintenance(serviceTask.maintenance()).staticServices(serviceTask.staticServices()).disableIpRewrite(serviceTask.disableIpRewrite()).autoDeleteOnStop(serviceTask.autoDeleteOnStop()).groups(serviceTask.groups()).associatedNodes(serviceTask.associatedNodes()).deletedFilesAfterStop(serviceTask.deletedFilesAfterStop()).jvmOptions((Collection)serviceTask.jvmOptions())).processParameters((Collection)serviceTask.processParameters())).environmentVariables((Map)serviceTask.environmentVariables()).templates(serviceTask.templates())).deployments(serviceTask.deployments())).inclusions(serviceTask.inclusions())).startPort(serviceTask.startPort()).minServiceCount(serviceTask.minServiceCount()).properties(serviceTask.propertyHolder())).processConfiguration(ProcessConfiguration.builder(serviceTask.processConfiguration()));
    }

    @Override
    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String runtime() {
        return this.runtime;
    }

    @Nullable
    public String hostAddress() {
        return this.hostAddress;
    }

    @Nullable
    public String javaCommand() {
        return this.javaCommand;
    }

    @NonNull
    public String nameSplitter() {
        return this.nameSplitter;
    }

    public boolean disableIpRewrite() {
        return this.disableIpRewrite;
    }

    public boolean maintenance() {
        return this.maintenance;
    }

    public boolean autoDeleteOnStop() {
        return this.autoDeleteOnStop;
    }

    public boolean staticServices() {
        return this.staticServices;
    }

    @Override
    @NonNull
    public Collection<String> jvmOptions() {
        return this.processConfiguration.jvmOptions();
    }

    @Override
    @NonNull
    public Collection<String> processParameters() {
        return this.processConfiguration.processParameters();
    }

    @Override
    public @Unmodifiable @NonNull Map<String, String> environmentVariables() {
        return this.processConfiguration.environmentVariables();
    }

    @NonNull
    public Collection<String> groups() {
        return this.groups;
    }

    @NonNull
    public Collection<String> associatedNodes() {
        return this.associatedNodes;
    }

    @NonNull
    public Collection<String> deletedFilesAfterStop() {
        return this.deletedFilesAfterStop;
    }

    @NonNull
    public ProcessConfiguration processConfiguration() {
        return this.processConfiguration;
    }

    public @Range(from=1L, to=65535L) int startPort() {
        return this.startPort;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int minServiceCount() {
        return this.minServiceCount;
    }

    @NonNull
    public ServiceTask clone() {
        try {
            return (ServiceTask)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @Override
    @Generated
    public String toString() {
        return "ServiceTask(name=" + this.name + ", runtime=" + this.runtime + ", hostAddress=" + this.hostAddress + ", javaCommand=" + this.javaCommand + ", nameSplitter=" + this.nameSplitter + ", disableIpRewrite=" + this.disableIpRewrite + ", maintenance=" + this.maintenance + ", autoDeleteOnStop=" + this.autoDeleteOnStop + ", staticServices=" + this.staticServices + ", groups=" + String.valueOf(this.groups) + ", associatedNodes=" + String.valueOf(this.associatedNodes) + ", deletedFilesAfterStop=" + String.valueOf(this.deletedFilesAfterStop) + ", processConfiguration=" + String.valueOf(this.processConfiguration) + ", startPort=" + this.startPort + ", minServiceCount=" + this.minServiceCount + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceTask)) {
            return false;
        }
        ServiceTask other = (ServiceTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.disableIpRewrite != other.disableIpRewrite) {
            return false;
        }
        if (this.maintenance != other.maintenance) {
            return false;
        }
        if (this.autoDeleteOnStop != other.autoDeleteOnStop) {
            return false;
        }
        if (this.staticServices != other.staticServices) {
            return false;
        }
        if (this.startPort != other.startPort) {
            return false;
        }
        if (this.minServiceCount != other.minServiceCount) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$runtime = this.runtime;
        String other$runtime = other.runtime;
        if (this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime)) {
            return false;
        }
        String this$hostAddress = this.hostAddress;
        String other$hostAddress = other.hostAddress;
        if (this$hostAddress == null ? other$hostAddress != null : !this$hostAddress.equals(other$hostAddress)) {
            return false;
        }
        String this$javaCommand = this.javaCommand;
        String other$javaCommand = other.javaCommand;
        if (this$javaCommand == null ? other$javaCommand != null : !this$javaCommand.equals(other$javaCommand)) {
            return false;
        }
        String this$nameSplitter = this.nameSplitter;
        String other$nameSplitter = other.nameSplitter;
        if (this$nameSplitter == null ? other$nameSplitter != null : !this$nameSplitter.equals(other$nameSplitter)) {
            return false;
        }
        Set<String> this$groups = this.groups;
        Set<String> other$groups = other.groups;
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Set<String> this$associatedNodes = this.associatedNodes;
        Set<String> other$associatedNodes = other.associatedNodes;
        if (this$associatedNodes == null ? other$associatedNodes != null : !((Object)this$associatedNodes).equals(other$associatedNodes)) {
            return false;
        }
        Set<String> this$deletedFilesAfterStop = this.deletedFilesAfterStop;
        Set<String> other$deletedFilesAfterStop = other.deletedFilesAfterStop;
        if (this$deletedFilesAfterStop == null ? other$deletedFilesAfterStop != null : !((Object)this$deletedFilesAfterStop).equals(other$deletedFilesAfterStop)) {
            return false;
        }
        ProcessConfiguration this$processConfiguration = this.processConfiguration;
        ProcessConfiguration other$processConfiguration = other.processConfiguration;
        return !(this$processConfiguration == null ? other$processConfiguration != null : !((Object)this$processConfiguration).equals(other$processConfiguration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceTask;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.disableIpRewrite ? 79 : 97);
        result = result * 59 + (this.maintenance ? 79 : 97);
        result = result * 59 + (this.autoDeleteOnStop ? 79 : 97);
        result = result * 59 + (this.staticServices ? 79 : 97);
        result = result * 59 + this.startPort;
        result = result * 59 + this.minServiceCount;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $runtime = this.runtime;
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        String $hostAddress = this.hostAddress;
        result = result * 59 + ($hostAddress == null ? 43 : $hostAddress.hashCode());
        String $javaCommand = this.javaCommand;
        result = result * 59 + ($javaCommand == null ? 43 : $javaCommand.hashCode());
        String $nameSplitter = this.nameSplitter;
        result = result * 59 + ($nameSplitter == null ? 43 : $nameSplitter.hashCode());
        Set<String> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Set<String> $associatedNodes = this.associatedNodes;
        result = result * 59 + ($associatedNodes == null ? 43 : ((Object)$associatedNodes).hashCode());
        Set<String> $deletedFilesAfterStop = this.deletedFilesAfterStop;
        result = result * 59 + ($deletedFilesAfterStop == null ? 43 : ((Object)$deletedFilesAfterStop).hashCode());
        ProcessConfiguration $processConfiguration = this.processConfiguration;
        result = result * 59 + ($processConfiguration == null ? 43 : ((Object)$processConfiguration).hashCode());
        return result;
    }

    public static class Builder
    extends ServiceConfigurationBase.Builder<ServiceTask, Builder> {
        private String name;
        private String hostAddress;
        private String javaCommand;
        private String runtime = "jvm";
        private String nameSplitter = "-";
        private boolean maintenance;
        private boolean staticServices;
        private boolean disableIpRewrite;
        private boolean autoDeleteOnStop = true;
        private Set<String> groups = new HashSet<String>();
        private Set<String> associatedNodes = new HashSet<String>();
        private Set<String> deletedFilesAfterStop = new HashSet<String>();
        private ProcessConfiguration.Builder processConfiguration = ProcessConfiguration.builder();
        private int startPort = -1;
        private int minServiceCount = 0;

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder runtime(@NonNull String runtime) {
            if (runtime == null) {
                throw new NullPointerException("runtime is marked non-null but is null");
            }
            this.runtime = runtime;
            return this;
        }

        @NonNull
        public Builder hostAddress(@Nullable String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        @NonNull
        public Builder javaCommand(@Nullable String javaCommand) {
            this.javaCommand = javaCommand;
            return this;
        }

        @NonNull
        public Builder nameSplitter(@NonNull String nameSplitter) {
            if (nameSplitter == null) {
                throw new NullPointerException("nameSplitter is marked non-null but is null");
            }
            this.nameSplitter = nameSplitter;
            return this;
        }

        @NonNull
        public Builder disableIpRewrite(boolean disableIpRewrite) {
            this.disableIpRewrite = disableIpRewrite;
            return this;
        }

        @NonNull
        public Builder maintenance(boolean maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        @NonNull
        public Builder autoDeleteOnStop(boolean autoDeleteOnStop) {
            this.autoDeleteOnStop = autoDeleteOnStop;
            return this;
        }

        @NonNull
        public Builder staticServices(boolean staticServices) {
            this.staticServices = staticServices;
            return this;
        }

        @NonNull
        public Builder associatedNodes(@NonNull Collection<String> associatedNodes) {
            if (associatedNodes == null) {
                throw new NullPointerException("associatedNodes is marked non-null but is null");
            }
            this.associatedNodes = new HashSet<String>(associatedNodes);
            return this;
        }

        @NonNull
        public Builder modifyAssociatedNodes(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.associatedNodes);
            return this;
        }

        @NonNull
        public Builder groups(@NonNull Collection<String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups is marked non-null but is null");
            }
            this.groups = new HashSet<String>(groups);
            return this;
        }

        @NonNull
        public Builder modifyGroups(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.groups);
            return this;
        }

        @NonNull
        public Builder deletedFilesAfterStop(@NonNull Collection<String> deletedFilesAfterStop) {
            if (deletedFilesAfterStop == null) {
                throw new NullPointerException("deletedFilesAfterStop is marked non-null but is null");
            }
            this.deletedFilesAfterStop = new HashSet<String>(deletedFilesAfterStop);
            return this;
        }

        @NonNull
        public Builder modifyDeletedFileAfterStop(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.deletedFilesAfterStop);
            return this;
        }

        @NonNull
        public Builder processConfiguration(@NonNull ProcessConfiguration.Builder processConfiguration) {
            if (processConfiguration == null) {
                throw new NullPointerException("processConfiguration is marked non-null but is null");
            }
            this.processConfiguration = processConfiguration;
            return this;
        }

        @NonNull
        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        @NonNull
        public Builder minServiceCount(int minServiceCount) {
            this.minServiceCount = minServiceCount;
            return this;
        }

        @NonNull
        public Builder maxHeapMemory(int maxHeapMemory) {
            this.processConfiguration.maxHeapMemorySize(maxHeapMemory);
            return this;
        }

        @NonNull
        public Builder serviceEnvironmentType(@NonNull ServiceEnvironmentType serviceEnvironmentType) {
            if (serviceEnvironmentType == null) {
                throw new NullPointerException("serviceEnvironmentType is marked non-null but is null");
            }
            this.processConfiguration.environment(serviceEnvironmentType);
            this.startPort = this.startPort == -1 ? serviceEnvironmentType.defaultStartPort() : this.startPort;
            return this;
        }

        @Override
        @NonNull
        public Builder jvmOptions(@NonNull Collection<String> jvmOptions) {
            if (jvmOptions == null) {
                throw new NullPointerException("jvmOptions is marked non-null but is null");
            }
            this.processConfiguration.jvmOptions(jvmOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyJvmOptions(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            this.processConfiguration.modifyJvmOptions(modifier);
            return this;
        }

        @Override
        @NonNull
        public Builder processParameters(@NonNull Collection<String> processParameters) {
            if (processParameters == null) {
                throw new NullPointerException("processParameters is marked non-null but is null");
            }
            this.processConfiguration.processParameters(processParameters);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyProcessParameters(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            this.processConfiguration.modifyProcessParameters(modifier);
            return this;
        }

        @Override
        @NonNull
        public Builder environmentVariables(@NonNull Map<String, String> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.processConfiguration.environmentVariables(environmentVariables);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyEnvironmentVariables(@NonNull Consumer<Map<String, String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            this.processConfiguration.modifyEnvironmentVariables(modifier);
            return this;
        }

        @Override
        @NonNull
        protected Builder self() {
            return this;
        }

        @Override
        @NonNull
        public ServiceTask build() {
            Preconditions.checkNotNull(this.name, "no name given");
            Preconditions.checkArgument(this.startPort > 0 && this.startPort <= 65535, "Invalid start port given");
            return new ServiceTask(this.name, this.runtime, this.hostAddress, this.javaCommand, this.nameSplitter, this.disableIpRewrite, this.maintenance, this.autoDeleteOnStop, this.staticServices, Set.copyOf(this.groups), Set.copyOf(this.associatedNodes), Set.copyOf(this.deletedFilesAfterStop), this.processConfiguration.build(), this.startPort, this.minServiceCount, Set.copyOf(this.templates), Set.copyOf(this.deployments), Set.copyOf(this.includes), this.properties.immutableCopy());
        }
    }
}

