/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.document.property.DocProperty;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceRemoteInclusion
implements DefaultedDocPropertyHolder,
Cloneable {
    public static final String NO_CACHE_STRATEGY = "none";
    public static final String KEEP_UNTIL_RESTART_STRATEGY = "until-node-restart";
    public static final DocProperty<Map<String, String>> HEADERS = DocProperty.genericProperty("headers", TypeFactory.parameterizedClass(Map.class, new Type[]{String.class, String.class}));
    private final String url;
    private final String destination;
    private final String cacheStrategy;
    private final Document properties;

    private ServiceRemoteInclusion(@NonNull String url, @NonNull String destination, @NonNull String cacheStrategy, @NonNull Document properties) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (cacheStrategy == null) {
            throw new NullPointerException("cacheStrategy is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.url = url;
        this.destination = destination;
        this.cacheStrategy = cacheStrategy;
        this.properties = properties;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceRemoteInclusion inclusion) {
        if (inclusion == null) {
            throw new NullPointerException("inclusion is marked non-null but is null");
        }
        return ServiceRemoteInclusion.builder().url(inclusion.url()).destination(inclusion.destination()).cacheStrategy(inclusion.cacheStrategy()).properties(inclusion.propertyHolder());
    }

    @NonNull
    public String url() {
        return this.url;
    }

    @NonNull
    public String destination() {
        return this.destination;
    }

    @NonNull
    public String cacheStrategy() {
        return this.cacheStrategy;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    @NonNull
    public String toString() {
        return this.url + ":" + this.destination;
    }

    @NonNull
    public ServiceRemoteInclusion clone() {
        try {
            return (ServiceRemoteInclusion)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServiceRemoteInclusion)) {
            return false;
        }
        ServiceRemoteInclusion that = (ServiceRemoteInclusion)other;
        return Objects.equals(this.url, that.url()) && Objects.equals(this.destination, that.destination());
    }

    public int hashCode() {
        return Objects.hash(this.url, this.destination);
    }

    public static class Builder {
        protected String url;
        protected String destination;
        protected String cacheStrategy = "none";
        protected Document properties = Document.emptyDocument();

        @NonNull
        public Builder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @NonNull
        public Builder destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return this;
        }

        @NonNull
        public Builder cacheStrategy(@NonNull String cacheStrategy) {
            if (cacheStrategy == null) {
                throw new NullPointerException("cacheStrategy is marked non-null but is null");
            }
            this.cacheStrategy = cacheStrategy;
            return this;
        }

        @NonNull
        public Builder properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.immutableCopy();
            return this;
        }

        @NonNull
        public ServiceRemoteInclusion build() {
            Preconditions.checkNotNull(this.url, "no url given");
            Preconditions.checkNotNull(this.destination, "no destination given");
            Preconditions.checkNotNull(this.cacheStrategy, "no cacheStrategy given");
            return new ServiceRemoteInclusion(this.url, this.destination, this.cacheStrategy, this.properties);
        }
    }
}

