/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import lombok.NonNull;

public class ServiceEnvironment
implements Named,
Cloneable {
    private final String name;
    private final String environmentType;

    protected ServiceEnvironment(@NonNull String name, @NonNull String environmentType) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (environmentType == null) {
            throw new NullPointerException("environmentType is marked non-null but is null");
        }
        this.name = name;
        this.environmentType = environmentType;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceEnvironment environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return ServiceEnvironment.builder().name(environment.name()).environmentType(environment.environmentType());
    }

    @Override
    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String environmentType() {
        return this.environmentType;
    }

    public ServiceEnvironment clone() {
        try {
            return (ServiceEnvironment)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public static class Builder {
        private String name;
        private String environmentType;

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder environmentType(@NonNull String environmentType) {
            if (environmentType == null) {
                throw new NullPointerException("environmentType is marked non-null but is null");
            }
            this.environmentType = environmentType;
            return this;
        }

        @NonNull
        public Builder environmentType(@NonNull ServiceEnvironmentType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.environmentType = type.name();
            return this;
        }

        @NonNull
        public ServiceEnvironment build() {
            Preconditions.checkNotNull(this.name, "no name given");
            Preconditions.checkNotNull(this.environmentType, "no environment type given");
            return new ServiceEnvironment(this.name, this.environmentType);
        }
    }
}

