/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.cloudnetservice.driver.channel.ChannelMessageTarget;
import eu.cloudnetservice.driver.service.ServiceCreateResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public class ServiceCreateRetryConfiguration
implements Cloneable {
    public static final ServiceCreateRetryConfiguration NO_RETRY = new ServiceCreateRetryConfiguration(0, List.of(), Map.of());
    private final int maxRetries;
    private final List<Long> backoffStrategy;
    private final Map<ServiceCreateResult.State, List<ChannelMessageTarget>> eventReceivers;

    protected ServiceCreateRetryConfiguration(int maxRetries, @NonNull List<Long> backoffStrategy, @NonNull Map<ServiceCreateResult.State, List<ChannelMessageTarget>> eventReceivers) {
        if (backoffStrategy == null) {
            throw new NullPointerException("backoffStrategy is marked non-null but is null");
        }
        if (eventReceivers == null) {
            throw new NullPointerException("eventReceivers is marked non-null but is null");
        }
        this.maxRetries = maxRetries;
        this.backoffStrategy = backoffStrategy;
        this.eventReceivers = eventReceivers;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceCreateRetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        return ServiceCreateRetryConfiguration.builder().maxRetries(retryConfiguration.maxRetries()).notificationReceivers(retryConfiguration.eventReceivers()).backoffStrategy(retryConfiguration.backoffStrategy().stream().map(Duration::ofMillis).toList());
    }

    public boolean enabled() {
        return this.maxRetries > 0 && !this.backoffStrategy.isEmpty();
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public @Unmodifiable @NonNull List<Long> backoffStrategy() {
        return this.backoffStrategy;
    }

    public @Unmodifiable @NonNull Map<ServiceCreateResult.State, List<ChannelMessageTarget>> eventReceivers() {
        return this.eventReceivers;
    }

    public ServiceCreateRetryConfiguration clone() {
        try {
            return (ServiceCreateRetryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @Generated
    public String toString() {
        return "ServiceCreateRetryConfiguration(maxRetries=" + this.maxRetries + ", backoffStrategy=" + String.valueOf(this.backoffStrategy) + ", eventReceivers=" + String.valueOf(this.eventReceivers) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceCreateRetryConfiguration)) {
            return false;
        }
        ServiceCreateRetryConfiguration other = (ServiceCreateRetryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxRetries != other.maxRetries) {
            return false;
        }
        List<Long> this$backoffStrategy = this.backoffStrategy;
        List<Long> other$backoffStrategy = other.backoffStrategy;
        if (this$backoffStrategy == null ? other$backoffStrategy != null : !((Object)this$backoffStrategy).equals(other$backoffStrategy)) {
            return false;
        }
        Map<ServiceCreateResult.State, List<ChannelMessageTarget>> this$eventReceivers = this.eventReceivers;
        Map<ServiceCreateResult.State, List<ChannelMessageTarget>> other$eventReceivers = other.eventReceivers;
        return !(this$eventReceivers == null ? other$eventReceivers != null : !((Object)this$eventReceivers).equals(other$eventReceivers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceCreateRetryConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxRetries;
        List<Long> $backoffStrategy = this.backoffStrategy;
        result = result * 59 + ($backoffStrategy == null ? 43 : ((Object)$backoffStrategy).hashCode());
        Map<ServiceCreateResult.State, List<ChannelMessageTarget>> $eventReceivers = this.eventReceivers;
        result = result * 59 + ($eventReceivers == null ? 43 : ((Object)$eventReceivers).hashCode());
        return result;
    }

    public static final class Builder {
        private int maxRetries = 1;
        private List<Duration> backoffStrategy = Lists.newArrayList(Duration.ofSeconds(15L));
        private Map<ServiceCreateResult.State, List<ChannelMessageTarget>> eventReceivers = new HashMap<ServiceCreateResult.State, List<ChannelMessageTarget>>();

        @NonNull
        public Builder maxRetries(@Range(from=1L, to=0x7FFFFFFFL) int maxRetries) {
            Preconditions.checkArgument(maxRetries > 0, "Max retries must be > 0");
            this.maxRetries = maxRetries;
            return this;
        }

        @NonNull
        public Builder fixedRetryDelay(@NonNull Duration delay) {
            if (delay == null) {
                throw new NullPointerException("delay is marked non-null but is null");
            }
            this.backoffStrategy = Lists.newArrayList(delay);
            return this;
        }

        @NonNull
        public Builder backoffStrategy(@NonNull Collection<Duration> backoffStrategy) {
            if (backoffStrategy == null) {
                throw new NullPointerException("backoffStrategy is marked non-null but is null");
            }
            this.backoffStrategy = new ArrayList<Duration>(backoffStrategy);
            return this;
        }

        @NonNull
        public Builder modifyBackoffStrategy(@NonNull Consumer<List<Duration>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.backoffStrategy);
            return this;
        }

        @NonNull
        public Builder notificationReceivers(ChannelMessageTarget ... receivers) {
            if (receivers == null) {
                throw new NullPointerException("receivers is marked non-null but is null");
            }
            return this.notificationReceivers(ServiceCreateResult.State.CREATED, receivers).notificationReceivers(ServiceCreateResult.State.FAILED, receivers);
        }

        @NonNull
        public Builder notificationReceivers(@NonNull ServiceCreateResult.State state, ChannelMessageTarget ... receivers) {
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            if (receivers == null) {
                throw new NullPointerException("receivers is marked non-null but is null");
            }
            this.eventReceivers.put(state, Arrays.asList(receivers));
            return this;
        }

        @NonNull
        public Builder notificationReceivers(@NonNull Map<ServiceCreateResult.State, List<ChannelMessageTarget>> eventReceivers) {
            if (eventReceivers == null) {
                throw new NullPointerException("eventReceivers is marked non-null but is null");
            }
            this.eventReceivers = new HashMap<ServiceCreateResult.State, List<ChannelMessageTarget>>(Map.copyOf(eventReceivers));
            return this;
        }

        @NonNull
        public ServiceCreateRetryConfiguration build() {
            Preconditions.checkArgument(!this.backoffStrategy.isEmpty(), "BackoffStrategy has no entries");
            return new ServiceCreateRetryConfiguration(this.maxRetries, this.backoffStrategy.stream().map(Duration::toMillis).toList(), Map.copyOf(this.eventReceivers));
        }
    }
}

