/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceCreateResult {
    public static final ServiceCreateResult FAILED = new ServiceCreateResult(State.FAILED, null, null);
    private final State state;
    private final UUID creationId;
    private final ServiceInfoSnapshot serviceInfo;

    private ServiceCreateResult(@NonNull State state, @Nullable UUID creationId, @Nullable ServiceInfoSnapshot serviceInfo) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        Preconditions.checkArgument(state == State.FAILED || creationId != null);
        Preconditions.checkArgument(state != State.CREATED || serviceInfo != null);
        this.state = state;
        this.creationId = creationId;
        this.serviceInfo = serviceInfo;
    }

    @NonNull
    public static ServiceCreateResult deferred(@NonNull UUID creationId) {
        if (creationId == null) {
            throw new NullPointerException("creationId is marked non-null but is null");
        }
        return new ServiceCreateResult(State.DEFERRED, creationId, null);
    }

    @NonNull
    public static ServiceCreateResult created(@NonNull ServiceInfoSnapshot serviceInfo) {
        if (serviceInfo == null) {
            throw new NullPointerException("serviceInfo is marked non-null but is null");
        }
        return new ServiceCreateResult(State.CREATED, serviceInfo.serviceId().uniqueId(), serviceInfo);
    }

    @NonNull
    public UUID creationId() {
        Preconditions.checkState(this.creationId != null, "Cannot retrieve creationId for State.FAILED");
        return this.creationId;
    }

    @NonNull
    public ServiceInfoSnapshot serviceInfo() {
        Preconditions.checkState(this.serviceInfo != null, "Can only retrieve service info for State.CREATED");
        return this.serviceInfo;
    }

    @NonNull
    public State state() {
        return this.state;
    }

    @Generated
    public String toString() {
        return "ServiceCreateResult(state=" + String.valueOf((Object)this.state) + ", creationId=" + String.valueOf(this.creationId) + ", serviceInfo=" + String.valueOf(this.serviceInfo) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceCreateResult)) {
            return false;
        }
        ServiceCreateResult other = (ServiceCreateResult)o;
        State this$state = this.state;
        State other$state = other.state;
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        UUID this$creationId = this.creationId;
        UUID other$creationId = other.creationId;
        if (this$creationId == null ? other$creationId != null : !((Object)this$creationId).equals(other$creationId)) {
            return false;
        }
        ServiceInfoSnapshot this$serviceInfo = this.serviceInfo;
        ServiceInfoSnapshot other$serviceInfo = other.serviceInfo;
        return !(this$serviceInfo == null ? other$serviceInfo != null : !((Object)this$serviceInfo).equals(other$serviceInfo));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        State $state = this.state;
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        UUID $creationId = this.creationId;
        result = result * 59 + ($creationId == null ? 43 : ((Object)$creationId).hashCode());
        ServiceInfoSnapshot $serviceInfo = this.serviceInfo;
        result = result * 59 + ($serviceInfo == null ? 43 : ((Object)$serviceInfo).hashCode());
        return result;
    }

    public static enum State {
        CREATED,
        DEFERRED,
        FAILED;

    }
}

