/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.provider.CloudServiceFactory;
import eu.cloudnetservice.driver.service.ProcessConfiguration;
import eu.cloudnetservice.driver.service.ServiceConfigurationBase;
import eu.cloudnetservice.driver.service.ServiceCreateResult;
import eu.cloudnetservice.driver.service.ServiceCreateRetryConfiguration;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceId;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public class ServiceConfiguration
extends ServiceConfigurationBase
implements Cloneable {
    protected final ServiceId serviceId;
    protected final ProcessConfiguration processConfig;
    protected final ServiceCreateRetryConfiguration retryConfiguration;
    protected final int port;
    protected final String runtime;
    protected final String hostAddress;
    protected final String javaCommand;
    protected final boolean autoDeleteOnStop;
    protected final boolean staticService;
    protected final Set<String> groups;
    protected final Set<String> deletedFilesAfterStop;

    protected ServiceConfiguration(@NonNull ServiceId serviceId, @NonNull ProcessConfiguration processConfig, @NonNull ServiceCreateRetryConfiguration retryConfiguration, int port, @NonNull String runtime, @Nullable String hostAddress, @Nullable String javaCommand, boolean autoDeleteOnStop, boolean staticService, @NonNull Set<String> groups, @NonNull Set<String> deletedFilesAfterStop, @NonNull Set<ServiceTemplate> templates, @NonNull Set<ServiceDeployment> deployments, @NonNull Set<ServiceRemoteInclusion> includes, @NonNull Document properties) {
        super(templates, deployments, includes, properties);
        if (serviceId == null) {
            throw new NullPointerException("serviceId is marked non-null but is null");
        }
        if (processConfig == null) {
            throw new NullPointerException("processConfig is marked non-null but is null");
        }
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        if (runtime == null) {
            throw new NullPointerException("runtime is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        if (deletedFilesAfterStop == null) {
            throw new NullPointerException("deletedFilesAfterStop is marked non-null but is null");
        }
        if (templates == null) {
            throw new NullPointerException("templates is marked non-null but is null");
        }
        if (deployments == null) {
            throw new NullPointerException("deployments is marked non-null but is null");
        }
        if (includes == null) {
            throw new NullPointerException("includes is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.serviceId = serviceId;
        this.port = port;
        this.runtime = runtime;
        this.hostAddress = hostAddress;
        this.javaCommand = javaCommand;
        this.autoDeleteOnStop = autoDeleteOnStop;
        this.staticService = staticService;
        this.processConfig = processConfig;
        this.groups = groups;
        this.retryConfiguration = retryConfiguration;
        this.deletedFilesAfterStop = deletedFilesAfterStop;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceTask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ServiceConfiguration.builder().taskName(task.name()).runtime(task.runtime()).hostAddress(task.hostAddress()).javaCommand(task.javaCommand()).nameSplitter(task.nameSplitter()).autoDeleteOnStop(task.autoDeleteOnStop()).staticService(task.staticServices()).allowedNodes(task.associatedNodes()).groups(task.groups()).deletedFilesAfterStop(task.deletedFilesAfterStop()).templates(task.templates())).deployments(task.deployments())).inclusions(task.inclusions())).jvmOptions(task.processConfiguration().jvmOptions())).processParameters(task.processConfiguration().processParameters())).environmentVariables((Map)task.processConfiguration().environmentVariables())).environment(task.processConfiguration().environment()).maxHeapMemory(task.processConfiguration().maxHeapMemorySize()).startPort(task.startPort());
    }

    @NonNull
    public static Builder builder(@NonNull ServiceConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return ((Builder)((Builder)((Builder)((Builder)ServiceConfiguration.builder().serviceId(ServiceId.builder(configuration.serviceId())).runtime(configuration.runtime()).hostAddress(configuration.hostAddress()).javaCommand(configuration.javaCommand()).autoDeleteOnStop(configuration.autoDeleteOnStop()).staticService(configuration.staticService()).startPort(configuration.port()).processConfig(ProcessConfiguration.builder(configuration.processConfig())).groups(configuration.groups()).deletedFilesAfterStop(configuration.deletedFilesAfterStop()).templates(configuration.templates())).deployments(configuration.deployments())).inclusions(configuration.inclusions())).properties(configuration.propertyHolder())).retryConfiguration(configuration.retryConfiguration());
    }

    @NonNull
    public ServiceId serviceId() {
        return this.serviceId;
    }

    @NonNull
    public ServiceCreateRetryConfiguration retryConfiguration() {
        return this.retryConfiguration;
    }

    public boolean autoDeleteOnStop() {
        return this.autoDeleteOnStop;
    }

    public boolean staticService() {
        return this.staticService;
    }

    @Nullable
    public String javaCommand() {
        return this.javaCommand;
    }

    @NonNull
    public String runtime() {
        return this.runtime;
    }

    public @UnknownNullability String hostAddress() {
        return this.hostAddress;
    }

    public @Unmodifiable @NonNull Set<String> groups() {
        return this.groups;
    }

    public @Unmodifiable @NonNull Set<String> deletedFilesAfterStop() {
        return this.deletedFilesAfterStop;
    }

    @NonNull
    public ProcessConfiguration processConfig() {
        return this.processConfig;
    }

    public @Range(from=0L, to=65535L) int port() {
        return this.port;
    }

    @Override
    public @Unmodifiable @NonNull Collection<String> jvmOptions() {
        return this.processConfig.jvmOptions();
    }

    @Override
    public @Unmodifiable @NonNull Collection<String> processParameters() {
        return this.processConfig.processParameters();
    }

    @Override
    public @Unmodifiable @NonNull Map<String, String> environmentVariables() {
        return this.processConfig.environmentVariables();
    }

    @NonNull
    public ServiceCreateResult createNewService() {
        CloudServiceFactory serviceFactory = InjectionLayer.boot().instance(CloudServiceFactory.class);
        return serviceFactory.createCloudService(this);
    }

    @NonNull
    public CompletableFuture<ServiceCreateResult> createNewServiceAsync() {
        CloudServiceFactory serviceFactory = InjectionLayer.boot().instance(CloudServiceFactory.class);
        return serviceFactory.createCloudServiceAsync(this);
    }

    @NonNull
    public ServiceConfiguration clone() {
        try {
            return (ServiceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @Override
    @Generated
    public String toString() {
        return "ServiceConfiguration(serviceId=" + String.valueOf(this.serviceId) + ", processConfig=" + String.valueOf(this.processConfig) + ", retryConfiguration=" + String.valueOf(this.retryConfiguration) + ", port=" + this.port + ", runtime=" + this.runtime + ", hostAddress=" + this.hostAddress + ", javaCommand=" + this.javaCommand + ", autoDeleteOnStop=" + this.autoDeleteOnStop + ", staticService=" + this.staticService + ", groups=" + String.valueOf(this.groups) + ", deletedFilesAfterStop=" + String.valueOf(this.deletedFilesAfterStop) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.autoDeleteOnStop != other.autoDeleteOnStop) {
            return false;
        }
        if (this.staticService != other.staticService) {
            return false;
        }
        ServiceId this$serviceId = this.serviceId;
        ServiceId other$serviceId = other.serviceId;
        if (this$serviceId == null ? other$serviceId != null : !((Object)this$serviceId).equals(other$serviceId)) {
            return false;
        }
        ProcessConfiguration this$processConfig = this.processConfig;
        ProcessConfiguration other$processConfig = other.processConfig;
        if (this$processConfig == null ? other$processConfig != null : !((Object)this$processConfig).equals(other$processConfig)) {
            return false;
        }
        ServiceCreateRetryConfiguration this$retryConfiguration = this.retryConfiguration;
        ServiceCreateRetryConfiguration other$retryConfiguration = other.retryConfiguration;
        if (this$retryConfiguration == null ? other$retryConfiguration != null : !((Object)this$retryConfiguration).equals(other$retryConfiguration)) {
            return false;
        }
        String this$runtime = this.runtime;
        String other$runtime = other.runtime;
        if (this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime)) {
            return false;
        }
        String this$hostAddress = this.hostAddress;
        String other$hostAddress = other.hostAddress;
        if (this$hostAddress == null ? other$hostAddress != null : !this$hostAddress.equals(other$hostAddress)) {
            return false;
        }
        String this$javaCommand = this.javaCommand;
        String other$javaCommand = other.javaCommand;
        if (this$javaCommand == null ? other$javaCommand != null : !this$javaCommand.equals(other$javaCommand)) {
            return false;
        }
        Set<String> this$groups = this.groups;
        Set<String> other$groups = other.groups;
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Set<String> this$deletedFilesAfterStop = this.deletedFilesAfterStop;
        Set<String> other$deletedFilesAfterStop = other.deletedFilesAfterStop;
        return !(this$deletedFilesAfterStop == null ? other$deletedFilesAfterStop != null : !((Object)this$deletedFilesAfterStop).equals(other$deletedFilesAfterStop));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.port;
        result = result * 59 + (this.autoDeleteOnStop ? 79 : 97);
        result = result * 59 + (this.staticService ? 79 : 97);
        ServiceId $serviceId = this.serviceId;
        result = result * 59 + ($serviceId == null ? 43 : ((Object)$serviceId).hashCode());
        ProcessConfiguration $processConfig = this.processConfig;
        result = result * 59 + ($processConfig == null ? 43 : ((Object)$processConfig).hashCode());
        ServiceCreateRetryConfiguration $retryConfiguration = this.retryConfiguration;
        result = result * 59 + ($retryConfiguration == null ? 43 : ((Object)$retryConfiguration).hashCode());
        String $runtime = this.runtime;
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        String $hostAddress = this.hostAddress;
        result = result * 59 + ($hostAddress == null ? 43 : $hostAddress.hashCode());
        String $javaCommand = this.javaCommand;
        result = result * 59 + ($javaCommand == null ? 43 : $javaCommand.hashCode());
        Set<String> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Set<String> $deletedFilesAfterStop = this.deletedFilesAfterStop;
        result = result * 59 + ($deletedFilesAfterStop == null ? 43 : ((Object)$deletedFilesAfterStop).hashCode());
        return result;
    }

    public static class Builder
    extends ServiceConfigurationBase.Builder<ServiceConfiguration, Builder> {
        protected ServiceId.Builder serviceId = ServiceId.builder();
        protected ProcessConfiguration.Builder processConfig = ProcessConfiguration.builder();
        protected ServiceCreateRetryConfiguration retryConfiguration = ServiceCreateRetryConfiguration.NO_RETRY;
        protected String javaCommand;
        protected String hostAddress;
        protected String runtime = "jvm";
        protected boolean staticService;
        protected boolean autoDeleteOnStop = true;
        protected int port = 44955;
        protected Set<String> groups = new HashSet<String>();
        protected Set<String> deletedFilesAfterStop = new HashSet<String>();

        @NonNull
        public Builder serviceId(@NonNull ServiceId.Builder serviceId) {
            if (serviceId == null) {
                throw new NullPointerException("serviceId is marked non-null but is null");
            }
            this.serviceId = serviceId;
            return this;
        }

        @NonNull
        public Builder processConfig(@NonNull ProcessConfiguration.Builder processConfig) {
            if (processConfig == null) {
                throw new NullPointerException("processConfig is marked non-null but is null");
            }
            this.processConfig = processConfig;
            return this;
        }

        @NonNull
        public Builder retryConfiguration(@NonNull ServiceCreateRetryConfiguration retryConfiguration) {
            if (retryConfiguration == null) {
                throw new NullPointerException("retryConfiguration is marked non-null but is null");
            }
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        @NonNull
        public Builder taskName(@NonNull String taskName) {
            if (taskName == null) {
                throw new NullPointerException("taskName is marked non-null but is null");
            }
            this.serviceId.taskName(taskName);
            return this;
        }

        @NonNull
        public Builder environment(@NonNull String environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            this.serviceId.environment(environment);
            this.processConfig.environment(environment);
            return this;
        }

        @NonNull
        public Builder environment(@NonNull ServiceEnvironmentType environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            this.serviceId.environment(environment);
            this.processConfig.environment(environment);
            return this;
        }

        @NonNull
        public Builder taskId(int taskId) {
            this.serviceId.taskServiceId(taskId);
            return this;
        }

        @NonNull
        public Builder uniqueId(@NonNull UUID uniqueId) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            this.serviceId.uniqueId(uniqueId);
            return this;
        }

        @NonNull
        public Builder javaCommand(@Nullable String javaCommand) {
            this.javaCommand = javaCommand;
            return this;
        }

        @NonNull
        public Builder nameSplitter(@NonNull String nameSplitter) {
            if (nameSplitter == null) {
                throw new NullPointerException("nameSplitter is marked non-null but is null");
            }
            this.serviceId.nameSplitter(nameSplitter);
            return this;
        }

        @NonNull
        public Builder node(@Nullable String nodeUniqueId) {
            this.serviceId.nodeUniqueId(nodeUniqueId);
            return this;
        }

        @NonNull
        public Builder allowedNodes(@NonNull Collection<String> allowedNodes) {
            if (allowedNodes == null) {
                throw new NullPointerException("allowedNodes is marked non-null but is null");
            }
            this.serviceId.allowedNodes(allowedNodes);
            return this;
        }

        @NonNull
        public Builder runtime(@NonNull String runtime) {
            if (runtime == null) {
                throw new NullPointerException("runtime is marked non-null but is null");
            }
            this.runtime = runtime;
            return this;
        }

        @NonNull
        public Builder hostAddress(@Nullable String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        @NonNull
        public Builder autoDeleteOnStop(boolean autoDeleteOnStop) {
            this.autoDeleteOnStop = autoDeleteOnStop;
            return this;
        }

        @NonNull
        public Builder staticService(boolean staticService) {
            this.staticService = staticService;
            return this;
        }

        @NonNull
        public Builder groups(@NonNull Collection<String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups is marked non-null but is null");
            }
            this.groups = new HashSet<String>(groups);
            return this;
        }

        @NonNull
        public Builder modifyGroups(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.groups);
            return this;
        }

        @NonNull
        public Builder deletedFilesAfterStop(@NonNull Collection<String> deletedFilesAfterStop) {
            if (deletedFilesAfterStop == null) {
                throw new NullPointerException("deletedFilesAfterStop is marked non-null but is null");
            }
            this.deletedFilesAfterStop = new HashSet<String>(deletedFilesAfterStop);
            return this;
        }

        @NonNull
        public Builder modifyDeletedFilesAfterStop(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.deletedFilesAfterStop);
            return this;
        }

        @NonNull
        public Builder maxHeapMemory(int maxHeapMemory) {
            this.processConfig.maxHeapMemorySize(maxHeapMemory);
            return this;
        }

        @Override
        @NonNull
        public Builder jvmOptions(@NonNull Collection<String> jvmOptions) {
            if (jvmOptions == null) {
                throw new NullPointerException("jvmOptions is marked non-null but is null");
            }
            this.processConfig.jvmOptions(jvmOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyJvmOptions(@NonNull Consumer<Collection<String>> jvmOptions) {
            if (jvmOptions == null) {
                throw new NullPointerException("jvmOptions is marked non-null but is null");
            }
            this.processConfig.modifyJvmOptions(jvmOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder processParameters(@NonNull Collection<String> processParameters) {
            if (processParameters == null) {
                throw new NullPointerException("processParameters is marked non-null but is null");
            }
            this.processConfig.processParameters(processParameters);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyProcessParameters(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            this.processConfig.modifyProcessParameters(modifier);
            return this;
        }

        @Override
        @NonNull
        public Builder environmentVariables(@NonNull Map<String, String> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.processConfig.environmentVariables(environmentVariables);
            return this;
        }

        @Override
        @NonNull
        public Builder modifyEnvironmentVariables(@NonNull Consumer<Map<String, String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            this.processConfig.modifyEnvironmentVariables(modifier);
            return this;
        }

        @NonNull
        public Builder startPort(@Range(from=0L, to=65535L) int startPort) {
            this.port = startPort;
            return this;
        }

        @Override
        @NonNull
        protected Builder self() {
            return this;
        }

        @Override
        @NonNull
        public ServiceConfiguration build() {
            Preconditions.checkArgument(this.port > 0 && this.port <= 65535, "invalid port provided");
            return new ServiceConfiguration(this.serviceId.build(), this.processConfig.build(), this.retryConfiguration, this.port, this.runtime, this.hostAddress, this.javaCommand, this.autoDeleteOnStop, this.staticService, Set.copyOf(this.groups), Set.copyOf(this.deletedFilesAfterStop), Set.copyOf(this.templates), Set.copyOf(this.deployments), Set.copyOf(this.includes), this.properties.immutableCopy());
        }
    }
}

