/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.service.ServiceConfigurationBase;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Unmodifiable;

public class GroupConfiguration
extends ServiceConfigurationBase
implements Cloneable,
Named {
    protected final String name;
    protected final Set<String> jvmOptions;
    protected final Set<String> processParameters;
    protected final Map<String, String> environmentVariables;
    protected final Set<String> targetEnvironments;

    protected GroupConfiguration(@NonNull String name, @NonNull Set<String> jvmOptions, @NonNull Set<String> processParameters, @NonNull Map<String, String> environmentVariables, @NonNull Set<String> targetEnvironments, @NonNull Set<ServiceTemplate> templates, @NonNull Set<ServiceDeployment> deployments, @NonNull Set<ServiceRemoteInclusion> includes, @NonNull Document properties) {
        super(templates, deployments, includes, properties);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (jvmOptions == null) {
            throw new NullPointerException("jvmOptions is marked non-null but is null");
        }
        if (processParameters == null) {
            throw new NullPointerException("processParameters is marked non-null but is null");
        }
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables is marked non-null but is null");
        }
        if (targetEnvironments == null) {
            throw new NullPointerException("targetEnvironments is marked non-null but is null");
        }
        if (templates == null) {
            throw new NullPointerException("templates is marked non-null but is null");
        }
        if (deployments == null) {
            throw new NullPointerException("deployments is marked non-null but is null");
        }
        if (includes == null) {
            throw new NullPointerException("includes is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.jvmOptions = jvmOptions;
        this.processParameters = processParameters;
        this.targetEnvironments = targetEnvironments;
        this.environmentVariables = environmentVariables;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull GroupConfiguration group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)GroupConfiguration.builder().name(group.name()).jvmOptions(group.jvmOptions())).processParameters(group.processParameters())).environmentVariables(group.environmentVariables())).targetEnvironments(group.targetEnvironments()).templates(group.templates())).deployments(group.deployments())).inclusions(group.inclusions());
    }

    @Override
    @NonNull
    public String name() {
        return this.name;
    }

    @Override
    public @Unmodifiable @NonNull Collection<String> jvmOptions() {
        return this.jvmOptions;
    }

    @Override
    public @Unmodifiable @NonNull Collection<String> processParameters() {
        return this.processParameters;
    }

    @Override
    public @Unmodifiable @NonNull Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public @Unmodifiable @NonNull Collection<String> targetEnvironments() {
        return this.targetEnvironments;
    }

    @NonNull
    public GroupConfiguration clone() {
        try {
            return (GroupConfiguration)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    @Override
    @Generated
    public String toString() {
        return "GroupConfiguration(name=" + this.name + ", jvmOptions=" + String.valueOf(this.jvmOptions) + ", processParameters=" + String.valueOf(this.processParameters) + ", environmentVariables=" + String.valueOf(this.environmentVariables) + ", targetEnvironments=" + String.valueOf(this.targetEnvironments) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupConfiguration)) {
            return false;
        }
        GroupConfiguration other = (GroupConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<String> this$jvmOptions = this.jvmOptions;
        Set<String> other$jvmOptions = other.jvmOptions;
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Set<String> this$processParameters = this.processParameters;
        Set<String> other$processParameters = other.processParameters;
        if (this$processParameters == null ? other$processParameters != null : !((Object)this$processParameters).equals(other$processParameters)) {
            return false;
        }
        Map<String, String> this$environmentVariables = this.environmentVariables;
        Map<String, String> other$environmentVariables = other.environmentVariables;
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Set<String> this$targetEnvironments = this.targetEnvironments;
        Set<String> other$targetEnvironments = other.targetEnvironments;
        return !(this$targetEnvironments == null ? other$targetEnvironments != null : !((Object)this$targetEnvironments).equals(other$targetEnvironments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<String> $jvmOptions = this.jvmOptions;
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Set<String> $processParameters = this.processParameters;
        result = result * 59 + ($processParameters == null ? 43 : ((Object)$processParameters).hashCode());
        Map<String, String> $environmentVariables = this.environmentVariables;
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Set<String> $targetEnvironments = this.targetEnvironments;
        result = result * 59 + ($targetEnvironments == null ? 43 : ((Object)$targetEnvironments).hashCode());
        return result;
    }

    public static class Builder
    extends ServiceConfigurationBase.Builder<GroupConfiguration, Builder> {
        protected String name;
        protected Set<String> targetEnvironments = new HashSet<String>();

        @NonNull
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @NonNull
        public Builder targetEnvironments(@NonNull Collection<String> targetEnvironments) {
            if (targetEnvironments == null) {
                throw new NullPointerException("targetEnvironments is marked non-null but is null");
            }
            this.targetEnvironments = new HashSet<String>(targetEnvironments);
            return this;
        }

        @NonNull
        public Builder modifyTargetEnvironments(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.targetEnvironments);
            return this;
        }

        @Override
        @NonNull
        protected Builder self() {
            return this;
        }

        @Override
        @NonNull
        public GroupConfiguration build() {
            Preconditions.checkNotNull(this.name, "no name given");
            return new GroupConfiguration(this.name, ImmutableSet.copyOf(this.jvmOptions), ImmutableSet.copyOf(this.processParameters), Map.copyOf(this.environmentVariables), Set.copyOf(this.targetEnvironments), Set.copyOf(this.templates), Set.copyOf(this.deployments), Set.copyOf(this.includes), this.properties.immutableCopy());
        }
    }
}

