/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.service.GroupConfiguration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface GroupConfigurationProvider {
    public void reload();

    @NonNull
    public @UnmodifiableView Collection<GroupConfiguration> groupConfigurations();

    @Nullable
    public GroupConfiguration groupConfiguration(@NonNull String var1);

    public boolean addGroupConfiguration(@NonNull GroupConfiguration var1);

    public void removeGroupConfigurationByName(@NonNull String var1);

    public void removeGroupConfiguration(@NonNull GroupConfiguration var1);

    @NonNull
    default public CompletableFuture<Void> reloadAsync() {
        return TaskUtil.runAsync(this::reload);
    }

    @NonNull
    default public CompletableFuture<Collection<GroupConfiguration>> groupConfigurationsAsync() {
        return TaskUtil.supplyAsync(this::groupConfigurations);
    }

    @NonNull
    default public CompletableFuture<GroupConfiguration> groupConfigurationAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.groupConfiguration(name));
    }

    @NonNull
    default public CompletableFuture<Boolean> addGroupConfigurationAsync(@NonNull GroupConfiguration groupConfiguration) {
        if (groupConfiguration == null) {
            throw new NullPointerException("groupConfiguration is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.addGroupConfiguration(groupConfiguration));
    }

    @NonNull
    default public CompletableFuture<Void> removeGroupConfigurationByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.removeGroupConfigurationByName(name));
    }

    @NonNull
    default public CompletableFuture<Void> removeGroupConfigurationAsync(@NonNull GroupConfiguration groupConfiguration) {
        if (groupConfiguration == null) {
            throw new NullPointerException("groupConfiguration is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.removeGroupConfiguration(groupConfiguration));
    }
}

