/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCChained;
import eu.cloudnetservice.driver.provider.SpecificCloudServiceProvider;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface CloudServiceProvider {
    @RPCChained
    @NonNull
    public SpecificCloudServiceProvider serviceProvider(@NonNull UUID var1);

    @RPCChained
    @NonNull
    public SpecificCloudServiceProvider serviceProviderByName(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> services();

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> runningServices();

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByTask(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByEnvironment(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByGroup(@NonNull String var1);

    public int serviceCount();

    public int serviceCountByGroup(@NonNull String var1);

    public int serviceCountByTask(@NonNull String var1);

    @Nullable
    public ServiceInfoSnapshot serviceByName(@NonNull String var1);

    @Nullable
    public ServiceInfoSnapshot service(@NonNull UUID var1);

    @NonNull
    default public CompletableFuture<Collection<ServiceInfoSnapshot>> servicesAsync() {
        return TaskUtil.supplyAsync(this::services);
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceInfoSnapshot>> runningServicesAsync() {
        return TaskUtil.supplyAsync(this::runningServices);
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceInfoSnapshot>> servicesByTaskAsync(@NonNull String taskName) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.servicesByTask(taskName));
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceInfoSnapshot>> servicesByEnvironmentAsync(@NonNull String environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.servicesByEnvironment(environment));
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceInfoSnapshot>> servicesByGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.servicesByGroup(group));
    }

    @NonNull
    default public CompletableFuture<Integer> serviceCountAsync() {
        return TaskUtil.supplyAsync(this::serviceCount);
    }

    @NonNull
    default public CompletableFuture<Integer> serviceCountByGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.serviceCountByGroup(group));
    }

    @NonNull
    default public CompletableFuture<Integer> serviceCountByTaskAsync(@NonNull String taskName) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.serviceCountByTask(taskName));
    }

    @NonNull
    default public CompletableFuture<ServiceInfoSnapshot> serviceByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.serviceByName(name));
    }

    @NonNull
    default public CompletableFuture<ServiceInfoSnapshot> serviceAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.service(uniqueId));
    }
}

