/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.scheduler;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.NonNull;

final class TaskSchedulingAction
implements Runnable {
    private final ThreadPoolExecutor targetExecutor;
    private final LinkedBlockingQueue<Runnable> unscheduledTasks;

    public TaskSchedulingAction(@NonNull ThreadPoolExecutor targetExecutor, @NonNull LinkedBlockingQueue<Runnable> unscheduledTaskQueue) {
        if (targetExecutor == null) {
            throw new NullPointerException("targetExecutor is marked non-null but is null");
        }
        if (unscheduledTaskQueue == null) {
            throw new NullPointerException("unscheduledTaskQueue is marked non-null but is null");
        }
        this.targetExecutor = targetExecutor;
        this.unscheduledTasks = unscheduledTaskQueue;
    }

    @Override
    public void run() {
        block3: while (true) {
            try {
                while (true) {
                    Runnable nextTask = this.unscheduledTasks.take();
                    if (this.targetExecutor.isShutdown()) break block3;
                    this.targetExecutor.execute(nextTask);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                continue;
            }
            break;
        }
    }

    public void scheduleTask(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        this.unscheduledTasks.offer(task);
    }
}

