/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.scheduler;

import eu.cloudnetservice.driver.network.scheduler.FallbackRejectionHandler;
import eu.cloudnetservice.driver.network.scheduler.NetworkTaskScheduler;
import eu.cloudnetservice.driver.network.scheduler.TaskSchedulingAction;
import eu.cloudnetservice.driver.network.scheduler.TimedSynchronousQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import lombok.NonNull;

public final class ScalingNetworkTaskScheduler
implements NetworkTaskScheduler {
    private static final int BASE_QUEUE_TIMEOUT = 150;
    private static final int MINIMUM_QUEUE_TIMEOUT = 50;
    private static final double QUEUE_TIMOUT_DECAY_FACTOR = 0.95;
    private final AtomicBoolean active;
    private final ThreadPoolExecutor coreExecutor;
    private final ThreadPoolExecutor fallbackExecutor;
    private final TaskSchedulingAction taskScheduler;

    public ScalingNetworkTaskScheduler(@NonNull ThreadFactory threadFactory, int maximumCorePoolSize) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        this.active = new AtomicBoolean(true);
        this.fallbackExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        LinkedBlockingQueue<Runnable> unscheduledTaskQueue = new LinkedBlockingQueue<Runnable>();
        LongSupplier timeoutSupplier = () -> {
            int scheduledTasks = unscheduledTaskQueue.size();
            double timeout = 150.0 * Math.pow(0.95, scheduledTasks);
            return (long)Math.clamp(timeout, 50.0, 150.0);
        };
        TimedSynchronousQueue<Runnable> workQueue = new TimedSynchronousQueue<Runnable>(timeoutSupplier);
        FallbackRejectionHandler fallbackDelegatingRejectionHandler = new FallbackRejectionHandler(this.fallbackExecutor);
        this.coreExecutor = new ThreadPoolExecutor(maximumCorePoolSize / 2, maximumCorePoolSize, 30L, TimeUnit.SECONDS, workQueue, threadFactory, fallbackDelegatingRejectionHandler);
        workQueue.parentExecutor(this.coreExecutor);
        this.taskScheduler = new TaskSchedulingAction(this.coreExecutor, unscheduledTaskQueue);
        Thread.ofVirtual().name("NetworkTaskScheduler").start(this.taskScheduler);
    }

    @Override
    public void shutdown() {
        if (this.active.compareAndSet(true, false)) {
            this.coreExecutor.shutdownNow();
            this.fallbackExecutor.shutdownNow();
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (!this.active.get()) {
            throw new RejectedExecutionException("scheduler was shut down");
        }
        this.taskScheduler.scheduleTask(command);
    }
}

