/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.listener;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.util.RPCExceptionUtil;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandlerRegistry;
import eu.cloudnetservice.driver.network.rpc.handler.RPCInvocationContext;
import eu.cloudnetservice.driver.network.rpc.handler.RPCInvocationResult;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public final class RPCPacketListener
implements PacketListener {
    private final RPCHandlerRegistry rpcHandlerRegistry;

    @Inject
    public RPCPacketListener(@NonNull RPCHandlerRegistry rpcHandlerRegistry) {
        if (rpcHandlerRegistry == null) {
            throw new NullPointerException("rpcHandlerRegistry is marked non-null but is null");
        }
        this.rpcHandlerRegistry = rpcHandlerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        DataBuf content = packet.content();
        boolean resultExpected = packet.uniqueId() != null;
        try {
            int rpcDepth = content.readInt();
            if (rpcDepth <= 0) {
                if (resultExpected) {
                    DataBuf.Mutable resultContent = DataBufFactory.defaultFactory().createWithExpectedSize(1).writeByte((byte)2).writeString("invalid chain length");
                    this.sendResponseData(channel, packet, resultContent);
                }
                return;
            }
            if (rpcDepth > 1) {
                this.executeRPCChainStep(rpcDepth, 1, resultExpected, content, packet, channel, null);
            } else {
                String targetClassName = content.readString();
                RPCInvocationContext invocationContext = this.buildContext(content, null);
                CompletableFuture<RPCInvocationResult> handlingTask = this.postRPCRequestToHandler(targetClassName, invocationContext);
                if (resultExpected) {
                    this.waitForInvocationCompletion(handlingTask, result -> {
                        DataBuf resultContent = this.serializeHandlingResult((RPCInvocationResult)result);
                        this.sendResponseData(channel, packet, resultContent);
                    });
                }
            }
        }
        finally {
            content.forceRelease();
        }
    }

    private void waitForInvocationCompletion(@Nullable CompletableFuture<RPCInvocationResult> invocationTask, @NonNull Consumer<RPCInvocationResult> callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (invocationTask == null) {
            callback.accept(null);
        } else {
            invocationTask.whenComplete((result, throwable) -> callback.accept((RPCInvocationResult)result));
        }
    }

    private void executeRPCChainStep(int chainDepth, int currentDepth, boolean resultExpected, @NonNull DataBuf content, @NonNull Packet request, @NonNull NetworkChannel channel, @Nullable Object previousMethodReturnValue) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        String targetClassName = content.readString();
        RPCInvocationContext invocationContext = this.buildContext(content, previousMethodReturnValue);
        CompletableFuture<RPCInvocationResult> invocationTask = this.postRPCRequestToHandler(targetClassName, invocationContext);
        this.waitForInvocationCompletion(invocationTask, invocationResult -> {
            boolean stillWorkTodo = currentDepth != chainDepth;
            RPCInvocationResult selector2$temp = invocationResult;
            int index$3 = 0;
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RPCInvocationResult.Success.class, RPCInvocationResult.Success.class}, (RPCInvocationResult)selector2$temp, index$3)) {
                    case 0: {
                        RPCInvocationResult.Success $b$0 = (RPCInvocationResult.Success)selector2$temp;
                        try {
                            Object patt4$temp;
                            Object result = patt4$temp = $b$0.invocationResult();
                            patt4$temp = $b$0.invocationHandler();
                            patt4$temp = $b$0.invokedMethod();
                            if (result != null && stillWorkTodo) {
                                int nextChainDepth = currentDepth + 1;
                                this.executeRPCChainStep(chainDepth, nextChainDepth, resultExpected, content, request, channel, result);
                                return;
                            }
                            index$3 = 1;
                            continue block7;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    case 1: {
                        RPCMethodMetadata invokedMethod;
                        RPCHandler handler;
                        RPCInvocationResult.Success $b$1 = (RPCInvocationResult.Success)selector2$temp;
                        {
                            RPCMethodMetadata patt9$temp;
                            RPCHandler patt8$temp;
                            Object patt7$temp;
                            Object result = patt7$temp = $b$1.invocationResult();
                            handler = patt8$temp = $b$1.invocationHandler();
                            invokedMethod = patt9$temp = $b$1.invokedMethod();
                            if (result != null || !stillWorkTodo) {
                                index$3 = 2;
                                continue block7;
                            }
                            if (!resultExpected) return;
                        }
                        String msg = String.format("Cannot invoke next method in chain because the return value of %s%s is null", invokedMethod.name(), invokedMethod.methodType());
                        NullPointerException exception = new NullPointerException(msg);
                        exception.setStackTrace(RPCExceptionUtil.UNASSIGNED_STACK);
                        RPCInvocationResult.Failure remappedResult = new RPCInvocationResult.Failure(exception, handler, invokedMethod);
                        DataBuf resultContent = this.serializeHandlingResult(remappedResult);
                        this.sendResponseData(channel, request, resultContent);
                        return;
                    }
                }
                break;
            }
            if (!resultExpected) return;
            DataBuf resultContent = this.serializeHandlingResult((RPCInvocationResult)invocationResult);
            this.sendResponseData(channel, request, resultContent);
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private DataBuf serializeHandlingResult(@Nullable RPCInvocationResult invocationResult) {
        DataBuf dataBuf;
        RPCInvocationResult rPCInvocationResult = invocationResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RPCInvocationResult.Success.class, RPCInvocationResult.Failure.class, RPCInvocationResult.BadRequest.class, RPCInvocationResult.ServerError.class}, (RPCInvocationResult)rPCInvocationResult, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                dataBuf = DataBuf.empty().writeByte((byte)2).writeString("missing explicitly defined target handler to call");
                return dataBuf;
            }
            case 0: {
                Object result;
                RPCInvocationResult.Success success = (RPCInvocationResult.Success)rPCInvocationResult;
                try {
                    Object object;
                    result = object = success.invocationResult();
                    object = success.invocationHandler();
                    object = success.invokedMethod();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ObjectMapper objectMapper = invocationResult.invocationHandler().objectMapper();
                DataBuf.Mutable baseResponseData = DataBuf.empty().writeByte((byte)0);
                dataBuf = objectMapper.writeObject(baseResponseData, result);
                return dataBuf;
            }
            case 1: {
                DataBuf.Mutable baseResponseData;
                Throwable thrown;
                RPCInvocationResult.Failure failure = (RPCInvocationResult.Failure)rPCInvocationResult;
                {
                    Object object = failure.caughtException();
                    thrown = object;
                    object = failure.invocationHandler();
                    object = failure.invokedMethod();
                    baseResponseData = DataBuf.empty().writeByte((byte)1);
                }
                dataBuf = RPCExceptionUtil.serializeHandlingException(baseResponseData, thrown);
                return dataBuf;
            }
            case 2: {
                RPCInvocationResult.BadRequest badRequest = (RPCInvocationResult.BadRequest)rPCInvocationResult;
                {
                    Object object = badRequest.detailMessage();
                    String message = object;
                    object = badRequest.invocationHandler();
                    dataBuf = DataBuf.empty().writeByte((byte)2).writeString(message);
                    return dataBuf;
                }
            }
            case 3: 
        }
        RPCInvocationResult.ServerError serverError = (RPCInvocationResult.ServerError)rPCInvocationResult;
        {
            Object object = serverError.detailMessage();
            String message = object;
            object = serverError.invocationHandler();
            dataBuf = DataBuf.empty().writeByte((byte)3).writeString(message);
        }
        return dataBuf;
    }

    private void sendResponseData(@NonNull NetworkChannel channel, @NonNull Packet request, @NonNull DataBuf response) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Packet responsePacket = request.constructResponse(response);
        channel.sendPacket(responsePacket);
    }

    @Nullable
    private CompletableFuture<RPCInvocationResult> postRPCRequestToHandler(@NonNull String targetClassName, @NonNull RPCInvocationContext context) {
        if (targetClassName == null) {
            throw new NullPointerException("targetClassName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        RPCHandler handler = this.rpcHandlerRegistry.handler(targetClassName);
        return handler == null ? null : handler.handle(context);
    }

    @NonNull
    private RPCInvocationContext buildContext(@NonNull DataBuf content, @Nullable Object workingInstance) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        String methodName = content.readString();
        String methodDescriptor = content.readString();
        return RPCInvocationContext.builder().methodName(methodName).methodDescriptor(methodDescriptor).argumentInformation(content).workingInstance(workingInstance).build();
    }
}

