/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.introspec;

import eu.cloudnetservice.driver.network.rpc.annotation.RPCChained;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCNoResult;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCTimeout;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.invoke.MethodType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.BitSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record RPCMethodMetadata(boolean concrete, boolean asyncReturnType, boolean compilerGenerated, boolean executionResultIgnored, @NonNull String name, @NonNull Type returnType, @NonNull Type unwrappedReturnType, @NonNull Type[] parameterTypes, @NonNull MethodType methodType, @NonNull Class<?> definingClass, @Nullable Duration executionTimeout, @Nullable MethodChainMetadata chainMetadata) {
    @Generated
    public RPCMethodMetadata(boolean concrete, boolean asyncReturnType, boolean compilerGenerated, boolean executionResultIgnored, @NonNull String name, @NonNull Type returnType, @NonNull Type unwrappedReturnType, @NonNull Type[] parameterTypes, @NonNull MethodType methodType, @NonNull Class<?> definingClass, @Nullable Duration executionTimeout, @Nullable MethodChainMetadata chainMetadata) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (returnType == null) {
            throw new NullPointerException("returnType is marked non-null but is null");
        }
        if (unwrappedReturnType == null) {
            throw new NullPointerException("unwrappedReturnType is marked non-null but is null");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes is marked non-null but is null");
        }
        if (methodType == null) {
            throw new NullPointerException("methodType is marked non-null but is null");
        }
        if (definingClass == null) {
            throw new NullPointerException("definingClass is marked non-null but is null");
        }
    }

    @NonNull
    static RPCMethodMetadata fromMethod(@NonNull Method method) {
        Type[] paramTypes;
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        RPCChained chainedAnnotation = method.getAnnotation(RPCChained.class);
        boolean executionResultIgnored = method.isAnnotationPresent(RPCNoResult.class);
        Duration rpcTimeout = RPCClassMetadata.parseRPCTimeout(method.getAnnotation(RPCTimeout.class));
        Type genericReturnType = method.getGenericReturnType();
        Type unwrappedFutureReturnType = RPCMethodMetadata.unwrapWrappedFutureType(method, genericReturnType);
        Type unwrappedReturnType = Objects.requireNonNullElse(unwrappedFutureReturnType, genericReturnType);
        Class<?> rawUnwrappedReturnType = GenericTypeReflector.erase(unwrappedReturnType);
        RPCMethodMetadata.validateBounds(method, unwrappedReturnType);
        for (Type paramType : paramTypes = method.getGenericParameterTypes()) {
            RPCMethodMetadata.validateBounds(method, paramType);
        }
        MethodChainMetadata chainMetadata = RPCMethodMetadata.extractAndValidateChainMeta(method, rawUnwrappedReturnType, chainedAnnotation);
        boolean concrete = !Modifier.isAbstract(method.getModifiers());
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return new RPCMethodMetadata(concrete, unwrappedFutureReturnType != null, method.isSynthetic(), executionResultIgnored, method.getName(), method.getGenericReturnType(), unwrappedReturnType, paramTypes, methodType, method.getDeclaringClass(), rpcTimeout, chainMetadata);
    }

    private static void validateBounds(@NonNull Method method, @NonNull Type type) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Class<?> rawType = GenericTypeReflector.erase(type);
        if (!GenericTypeReflector.isFullyBound(type) || rawType == Object.class || rawType == CompletionStage.class || Future.class.isAssignableFrom(rawType)) {
            throw new IllegalStateException(String.format("method %s in %s has too lose bounds to be properly functional with RPC", method.getName(), method.getDeclaringClass().getName()));
        }
        if (rawType.isArray()) {
            RPCMethodMetadata.validateBounds(method, rawType.getComponentType());
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            RPCMethodMetadata.validateBounds(method, genericArrayType.getGenericComponentType());
        }
    }

    @Nullable
    private static MethodChainMetadata extractAndValidateChainMeta(@NonNull Method method, @NonNull Class<?> rawReturnType, @Nullable RPCChained chainAnnotation) {
        Class<?> chainBaseImpl;
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (rawReturnType == null) {
            throw new NullPointerException("rawReturnType is marked non-null but is null");
        }
        if (chainAnnotation == null) {
            return null;
        }
        Class<?> givenChainBaseType = chainAnnotation.baseImplementation();
        Class<?> clazz = chainBaseImpl = givenChainBaseType == Object.class ? null : givenChainBaseType;
        if (chainBaseImpl != null && !rawReturnType.isAssignableFrom(chainBaseImpl)) {
            throw new IllegalStateException(String.format("chain annotation for method %s in %s declared base type %s which is not a subtype of %s", method.getName(), method.getDeclaringClass().getName(), chainBaseImpl.getName(), rawReturnType.getName()));
        }
        if (chainBaseImpl != null) {
            RPCClassMetadata.validateTargetClass(chainBaseImpl);
            RPCMethodMetadata.validateChainBaseClass(method, chainBaseImpl);
        } else {
            RPCClassMetadata.validateTargetClass(rawReturnType);
            RPCMethodMetadata.validateChainBaseClass(method, rawReturnType);
        }
        int[] parameterMappings = chainAnnotation.parameterMapping();
        if (parameterMappings.length != 0) {
            if (parameterMappings.length % 2 != 0) {
                throw new IllegalStateException(String.format("chain parameter mapping on method %s in %s must have a divisible by 2 mapping, got %d mappings", method.getName(), method.getDeclaringClass().getName(), parameterMappings.length));
            }
            if (parameterMappings.length / 2 > method.getParameterCount()) {
                throw new IllegalStateException(String.format("chain parameter mapping on method %s in %s defines more mapping than parameters, got %d mappings and %d params", method.getName(), method.getDeclaringClass().getName(), parameterMappings.length / 2, method.getParameterCount()));
            }
            BitSet seenParamIndexes = new BitSet(parameterMappings.length / 2);
            BitSet seenConstructorIndexes = new BitSet(parameterMappings.length / 2);
            for (int index = 0; index < parameterMappings.length; index += 2) {
                int paramIndex = parameterMappings[index];
                int constructorIndex = parameterMappings[index + 1];
                if (paramIndex >= method.getParameterCount() || constructorIndex < 0 || paramIndex < RPCInternalInstanceFactory.SpecialArg.SPECIAL_ARG_MAX_INDEX) {
                    throw new IllegalStateException(String.format("chain parameter of method %s in %s mapped incorrectly, param index: %d, constructor index: %d", method.getName(), method.getDeclaringClass().getName(), paramIndex, constructorIndex));
                }
                if (seenParamIndexes.get(paramIndex) || seenConstructorIndexes.get(constructorIndex)) {
                    throw new IllegalStateException(String.format("chain parameter on method %s in %s mapped twice, either from param %d or to constructor param %d", method.getName(), method.getDeclaringClass().getName(), paramIndex, constructorIndex));
                }
                seenParamIndexes.set(paramIndex);
                seenConstructorIndexes.set(constructorIndex);
            }
        }
        int generationFlags = chainAnnotation.generationFlags();
        return new MethodChainMetadata(generationFlags, parameterMappings, chainBaseImpl);
    }

    private static void validateChainBaseClass(@NonNull Method method, @NonNull Class<?> chainBaseImpl) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (chainBaseImpl == null) {
            throw new NullPointerException("chainBaseImpl is marked non-null but is null");
        }
        if (chainBaseImpl.isSealed() || chainBaseImpl.isRecord()) {
            throw new IllegalStateException(String.format("cannot implement class %s returned from %s in %s for chained rpc invocations: class is a record or sealed", method.getName(), method.getDeclaringClass().getName(), chainBaseImpl.getName()));
        }
        if (chainBaseImpl.getPackageName().startsWith("java.")) {
            throw new IllegalStateException(String.format("cannot implemented %s returned from %s in %s for chained rpc invocation: class is from java namespace", method.getName(), method.getDeclaringClass().getName(), chainBaseImpl.getName()));
        }
    }

    @Nullable
    private static Type unwrapWrappedFutureType(@NonNull Method method, @NonNull Type type) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Class<?> rawType = GenericTypeReflector.erase(type);
        if (!Future.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (rawType != Future.class && rawType != CompletionStage.class && rawType != CompletableFuture.class) {
            throw new IllegalStateException(String.format("method %s in %s has unsupported future return type %s; must be CompletableFuture, CompletionStage or Future", method.getName(), method.getDeclaringClass().getName(), rawType.getName()));
        }
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException(String.format("Future return type of method %s in %s is not parameterized", method.getName(), method.getDeclaringClass().getName()));
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalStateException(String.format("Future return type of method %s in %s has %d parameter types, expected exactly 1", method.getName(), method.getDeclaringClass().getName(), typeArguments.length));
        }
        return typeArguments[0];
    }

    public record MethodChainMetadata(int generationFlags, int[] parameterMappings, @Nullable Class<?> baseImplementationType) {
    }
}

