/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.introspec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCTimeout;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class RPCClassMetadata {
    private static final Predicate<Method> STANDARD_IGNORED_METHOD_FILTER = m -> m.getName().equals("clone") && m.getParameterCount() == 0 || m.getName().equals("hashCode") && m.getParameterCount() == 0 && m.getReturnType() == Integer.TYPE || m.getName().equals("finalize") && m.getParameterCount() == 0 && m.getReturnType() == Void.TYPE || m.getName().equals("toString") && m.getParameterCount() == 0 && m.getReturnType() == String.class || m.getName().equals("equals") && m.getParameterCount() == 1 && m.getParameterTypes()[0] == Object.class;
    private final Class<?> target;
    private final Duration rpcTimeout;
    private final Table<String, String, RPCMethodMetadata> methods;

    private RPCClassMetadata(@NonNull Class<?> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
        this.rpcTimeout = RPCClassMetadata.parseRPCTimeout(target.getAnnotation(RPCTimeout.class));
        this.methods = HashBasedTable.create();
    }

    private RPCClassMetadata(@NonNull Class<?> target, @Nullable Duration rpcTimeout, @NonNull Table<String, String, RPCMethodMetadata> methods) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (methods == null) {
            throw new NullPointerException("methods is marked non-null but is null");
        }
        this.target = target;
        this.rpcTimeout = rpcTimeout;
        this.methods = methods;
    }

    @Nullable
    static Duration parseRPCTimeout(@Nullable RPCTimeout annotation) {
        if (annotation != null && annotation.timeout() >= 1L) {
            ChronoUnit timeoutUnit = annotation.unit().toChronoUnit();
            return Duration.of(annotation.timeout(), timeoutUnit);
        }
        return null;
    }

    static void validateTargetClass(@NonNull Class<?> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.isHidden() || target.isPrimitive() || target.isLocalClass() || target.isAnonymousClass()) {
            throw new IllegalArgumentException(String.format("class %s cannot be used with rpc: must not be hidden, primitive, local or anonymous", target.getName()));
        }
    }

    @NonNull
    public static RPCClassMetadata introspect(@NonNull Class<?> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        RPCClassMetadata.validateTargetClass(target);
        RPCClassMetadata metadata = new RPCClassMetadata(target);
        metadata.introspectMethods(target, new HashSet());
        return metadata;
    }

    private void introspectMethods(@NonNull Class<?> target, @NonNull Set<Class<?>> visitedClasses) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (visitedClasses == null) {
            throw new NullPointerException("visitedClasses is marked non-null but is null");
        }
        for (Method method : target.getDeclaredMethods()) {
            if (method.isSynthetic()) continue;
            if (this.methodVisibleToRoot(method)) {
                if (method.isAnnotationPresent(RPCIgnore.class) || STANDARD_IGNORED_METHOD_FILTER.test(method)) continue;
                RPCMethodMetadata metadata = RPCMethodMetadata.fromMethod(method);
                String methodDescriptor = metadata.methodType().descriptorString();
                if (this.methods.contains(metadata.name(), methodDescriptor)) continue;
                this.methods.put(metadata.name(), methodDescriptor, metadata);
                continue;
            }
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            throw new IllegalStateException(String.format("Detected abstract method %s in %s that is not visible to root type %s", method.getName(), method.getDeclaringClass().getName(), this.target.getName()));
        }
        this.introspectSuper(target, visitedClasses, clazz -> this.introspectMethods((Class<?>)clazz, visitedClasses));
    }

    private boolean methodVisibleToRoot(@NonNull Method method) {
        Package declaringPackage;
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        int modifiers = method.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        Package introspectingPackage = this.target.getPackage();
        return introspectingPackage == (declaringPackage = method.getDeclaringClass().getPackage());
    }

    private void introspectSuper(@NonNull Class<?> target, @NonNull Set<Class<?>> visitedClasses, @NonNull Consumer<Class<?>> introspectCallback) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (visitedClasses == null) {
            throw new NullPointerException("visitedClasses is marked non-null but is null");
        }
        if (introspectCallback == null) {
            throw new NullPointerException("introspectCallback is marked non-null but is null");
        }
        Class<?> superclass = target.getSuperclass();
        if (superclass != null && superclass != Object.class && visitedClasses.add(superclass)) {
            introspectCallback.accept(superclass);
        }
        for (Class<?> superInterface : target.getInterfaces()) {
            if (!visitedClasses.add(superInterface)) continue;
            introspectCallback.accept(superInterface);
        }
    }

    @NonNull
    public Class<?> targetClass() {
        return this.target;
    }

    @Nullable
    public Duration defaultRPCTimeout() {
        return this.rpcTimeout;
    }

    public @UnmodifiableView @NonNull Collection<RPCMethodMetadata> methods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    @NonNull
    public RPCClassMetadata freeze() {
        if (this.methods instanceof ImmutableTable) {
            return this;
        }
        ImmutableTable<String, String, RPCMethodMetadata> frozenMethods = ImmutableTable.copyOf(this.methods);
        return new RPCClassMetadata(this.target, this.rpcTimeout, frozenMethods);
    }

    public void unregisterMethod(@NonNull String name, @NonNull TypeDescriptor typeDescriptor) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (typeDescriptor == null) {
            throw new NullPointerException("typeDescriptor is marked non-null but is null");
        }
        this.methods.remove(name, typeDescriptor.descriptorString());
    }

    @NonNull
    public List<RPCMethodMetadata> findMethods(@NonNull Predicate<RPCMethodMetadata> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.methods.values().stream().filter(filter).toList();
    }

    @Nullable
    public RPCMethodMetadata findMethod(@NonNull String name, @NonNull TypeDescriptor typeDescriptor) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (typeDescriptor == null) {
            throw new NullPointerException("typeDescriptor is marked non-null but is null");
        }
        return this.methods.get(name, typeDescriptor.descriptorString());
    }
}

