/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.exception;

import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.NonNull;

public class RPCException
extends RuntimeException {
    public RPCException(@NonNull RPC rpc, @NonNull Exception root) {
        super(String.format("Unable to get yield result of rpc: %s", RPCException.formatRPC(rpc)), root);
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
    }

    public RPCException(@NonNull RPCChain chain, @NonNull Exception root) {
        super(String.format("Unable to get future result of chained rpc; stack: %s\n%s", RPCException.formatRPC(chain.tail()), chain.joins().stream().map(RPCException::formatChainedRPCEntry).collect(Collectors.joining("\n"))), root);
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
    }

    @NonNull
    protected static String formatRPC(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        return String.format("%s.%s(%s)", rpc.className(), rpc.methodName(), Arrays.toString(rpc.arguments()));
    }

    @NonNull
    protected static String formatChainedRPCEntry(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        return String.format(" at %s", RPCException.formatRPC(rpc));
    }
}

