/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufable;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import eu.cloudnetservice.driver.util.ClassAllocationUtil;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.function.Supplier;
import lombok.NonNull;

public final class DataBufableObjectSerializer
implements ObjectSerializer<DataBufable> {
    private final Cache<Class<?>, Supplier<Object>> cachedClassAllocators = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(6L)).build();

    @Override
    @NonNull
    public DataBufable read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("target type must be class");
        }
        Class targetClass = (Class)type;
        Supplier classAllocator = this.cachedClassAllocators.get(targetClass, ClassAllocationUtil::makeInstanceFactory);
        DataBufable allocatedInstance = (DataBufable)classAllocator.get();
        allocatedInstance.readData(source);
        return allocatedInstance;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull DataBufable object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        object.writeData(dataBuf);
    }
}

