/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCIgnore;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.AllocationStatistic;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassCodec;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassCodecGenerator;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public final class DataClassSerializer
implements ObjectSerializer<Object> {
    private final Cache<Class<?>, Tuple2<DataClassCodec, AllocationStatistic>> dataClassCodecCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(8L)).build();

    private static void ensureClassIsInstantiable(@NonNull Class<?> clazz) {
        boolean notInstantiable;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        boolean bl = notInstantiable = clazz.isPrimitive() || clazz.isHidden() || clazz.isInterface() || clazz.isLocalClass() || clazz.isAnonymousClass() || Modifier.isAbstract(clazz.getModifiers());
        if (notInstantiable) {
            throw new IllegalArgumentException(String.format("class %s is not instantiable", clazz.getName()));
        }
    }

    @Override
    @NonNull
    public Object read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("data class serializer called with non-class type");
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            int arraySize = source.readInt();
            Class<?> componentType = clazz.getComponentType();
            Object targetArray = Array.newInstance(componentType, arraySize);
            for (int index = 0; index < arraySize; ++index) {
                Object deserializedValue = caller.readObject(source, componentType);
                Array.set(targetArray, index, deserializedValue);
            }
            return targetArray;
        }
        DataClassSerializer.ensureClassIsInstantiable(clazz);
        DataClassCodec dataClassCodec = (DataClassCodec)this.dataClassCodecCache.get(clazz, target -> {
            DataClassCodec createdCodec = this.createDataClassCodec((Class<?>)target);
            return new Tuple2<DataClassCodec, AllocationStatistic>(createdCodec, new AllocationStatistic());
        }).first();
        return dataClassCodec.deserialize(source, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Object object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("data class serializer called with non-class type");
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            int arrayLength = Array.getLength(object);
            dataBuf.writeInt(arrayLength);
            for (int index = 0; index < arrayLength; ++index) {
                Object entry = Array.get(object, index);
                caller.writeObject(dataBuf, entry);
            }
        } else {
            DataClassSerializer.ensureClassIsInstantiable(clazz);
            Tuple2 codecInfo = this.dataClassCodecCache.get(clazz, target -> {
                DataClassCodec createdCodec = this.createDataClassCodec((Class<?>)target);
                return new Tuple2<DataClassCodec, AllocationStatistic>(createdCodec, new AllocationStatistic());
            });
            DataClassCodec dataClassCodec = (DataClassCodec)codecInfo.first();
            AllocationStatistic allocStatistic = (AllocationStatistic)codecInfo.second();
            int prevByteCount = dataBuf.readableBytes();
            try {
                dataBuf.ensureWriteable(allocStatistic.average());
                dataClassCodec.serialize(dataBuf, caller, object);
            }
            finally {
                int newByteCount = dataBuf.readableBytes();
                allocStatistic.add(newByteCount - prevByteCount);
            }
        }
    }

    @NonNull
    private DataClassCodec createDataClassCodec(@NonNull Class<?> targetType) {
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
        Class<?> currentTarget = targetType;
        ArrayList<Field> allFields = new ArrayList<Field>();
        ArrayList hierarchy = new ArrayList();
        do {
            Field[] fields;
            hierarchy.add(currentTarget);
            for (Field field : fields = currentTarget.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.isAnnotationPresent(RPCIgnore.class)) continue;
                allFields.add(field);
            }
        } while ((currentTarget = currentTarget.getSuperclass()) != Object.class);
        Class[] fieldTypes = (Class[])allFields.stream().map(Field::getType).toArray(Class[]::new);
        try {
            targetType.getDeclaredConstructor(fieldTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            List<String> paramTypeNames = Arrays.stream(fieldTypes).map(Class::getName).toList();
            throw new IllegalStateException(String.format("%s does not have a constructor with with param types %s", targetType.getName(), paramTypeNames));
        }
        return DataClassCodecGenerator.generateClassCodec(allFields, hierarchy);
    }
}

