/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCFieldGetter;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassCodec;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.util.CodeGenerationUtil;
import java.lang.classfile.ClassFile;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Opcode;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class DataClassCodecGenerator {
    private static final String FIELDS_FIELD_NAME = "fields";
    private static final String SUPER_CODEC_NAME = "nextCodec";
    private static final String SERIALIZE_METHOD_NAME = "serialize";
    private static final String DESERIALIZE_METHOD_NAME = "deserialize";
    private static final ClassDesc CD_TYPE = ClassDesc.of(Type.class.getName());
    private static final ClassDesc CD_FIELD = ClassDesc.of(Field.class.getName());
    private static final ClassDesc CD_FIELD_ARRAY = CD_FIELD.arrayType();
    private static final String FIELD_GET_TYPE_NAME = "getGenericType";
    private static final MethodTypeDesc MT_FIELD_GET_TYPE = MethodTypeDesc.of(CD_TYPE);
    private static final ClassDesc CD_DATA_BUF = ClassDesc.of(DataBuf.class.getName());
    private static final ClassDesc CD_DATA_BUF_MUT = ClassDesc.of(DataBuf.Mutable.class.getName());
    private static final ClassDesc CD_OBJECT_MAPPER = ClassDesc.of(ObjectMapper.class.getName());
    private static final ClassDesc CD_DATA_CLASS_CODEC = ClassDesc.of(DataClassCodec.class.getName());
    private static final String OBJECT_MAPPER_READ_NAME = "readObject";
    private static final String OBJECT_MAPPER_WRITE_NAME = "writeObject";
    private static final MethodTypeDesc MT_OBJECT_MAPPER_READ = MethodTypeDesc.of(ConstantDescs.CD_Object, CD_DATA_BUF, CD_TYPE);
    private static final MethodTypeDesc MT_OBJECT_MAPPER_WRITE = MethodTypeDesc.of(CD_DATA_BUF_MUT, CD_DATA_BUF_MUT, ConstantDescs.CD_Object);
    private static final MethodTypeDesc MT_CONSTRUCTOR = MethodTypeDesc.of(ConstantDescs.CD_void, CD_FIELD_ARRAY, CD_DATA_CLASS_CODEC);
    private static final MethodTypeDesc MT_DESERIALIZE = MethodTypeDesc.of(ConstantDescs.CD_Object, CD_DATA_BUF, CD_OBJECT_MAPPER);
    private static final MethodTypeDesc MT_SERIALIZE = MethodTypeDesc.of(ConstantDescs.CD_void, CD_DATA_BUF_MUT, CD_OBJECT_MAPPER, ConstantDescs.CD_Object);
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final MethodType MTR_CONSTRUCTOR = MethodType.methodType(Void.TYPE, Field[].class, DataClassCodec.class);

    private DataClassCodecGenerator() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static DataClassCodec generateClassCodec(@NonNull List<Field> allFields, @NonNull List<Class<?>> classHierarchy) {
        if (allFields == null) {
            throw new NullPointerException("allFields is marked non-null but is null");
        }
        if (classHierarchy == null) {
            throw new NullPointerException("classHierarchy is marked non-null but is null");
        }
        Class<?> rootType = classHierarchy.getFirst();
        SequencedCollection reversedHierarchy = classHierarchy.reversed();
        HashMap<Class, List> fieldsPerType = new HashMap<Class, List>();
        for (Field field : allFields) {
            List fieldsOfType = fieldsPerType.computeIfAbsent(field.getDeclaringClass(), clazz -> new ArrayList());
            fieldsOfType.add(field);
        }
        DataClassCodec previousCodec = null;
        for (Class hierarchyEntry : reversedHierarchy) {
            boolean root = rootType == hierarchyEntry;
            List fieldsOfType = (List)fieldsPerType.get(hierarchyEntry);
            if (fieldsOfType == null && !root) continue;
            Field[] fieldsToDeserialize = root ? allFields.toArray(EMPTY_FIELD_ARRAY) : EMPTY_FIELD_ARRAY;
            try {
                MethodHandles.Lookup lookup = DataClassCodecGenerator.generateClassCodecClass(hierarchyEntry, allFields, root);
                MethodHandle constructor = lookup.findConstructor(lookup.lookupClass(), MTR_CONSTRUCTOR);
                previousCodec = constructor.invoke(fieldsToDeserialize, previousCodec);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(String.format("unable to instantiate generated codec class for %s", hierarchyEntry.getName()), throwable);
            }
        }
        Objects.requireNonNull(previousCodec, "at least one codec must have been generated at this point");
        return previousCodec;
    }

    @NonNull
    private static MethodHandles.Lookup generateClassCodecClass(@NonNull Class<?> target, @NonNull List<Field> allFields, boolean root) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (allFields == null) {
            throw new NullPointerException("allFields is marked non-null but is null");
        }
        ClassDesc targetClassDesc = ClassDesc.ofDescriptor(target.descriptorString());
        ClassDesc classDesc = targetClassDesc.nested("RPC_DCC");
        byte[] classFileBytes = ClassFile.of().build(classDesc, classBuilder -> {
            classBuilder.withInterfaceSymbols(new ClassDesc[]{CD_DATA_CLASS_CODEC});
            classBuilder.withField(FIELDS_FIELD_NAME, CD_FIELD_ARRAY, 18);
            classBuilder.withField(SUPER_CODEC_NAME, CD_DATA_CLASS_CODEC, 18);
            classBuilder.withMethodBody("<init>", MT_CONSTRUCTOR, 1, code -> code.aload(0).invokespecial(ConstantDescs.CD_Object, "<init>", ConstantDescs.MTD_void).aload(0).aload(1).putfield(classDesc, FIELDS_FIELD_NAME, CD_FIELD_ARRAY).aload(0).aload(2).putfield(classDesc, SUPER_CODEC_NAME, CD_DATA_CLASS_CODEC).return_());
            classBuilder.withMethodBody(SERIALIZE_METHOD_NAME, MT_SERIALIZE, 1, code -> DataClassCodecGenerator.generateSerializeMethod(code, target, allFields, targetClassDesc, classDesc));
            classBuilder.withMethodBody(DESERIALIZE_METHOD_NAME, MT_DESERIALIZE, 1, code -> {
                if (root) {
                    DataClassCodecGenerator.generateDeserializeMethod(code, allFields, targetClassDesc, classDesc);
                } else {
                    code.aconst_null().areturn();
                }
            });
        });
        return CodeGenerationUtil.defineNestedClass(target, classFileBytes);
    }

    private static void generateSerializeMethod(@NonNull CodeBuilder code, @NonNull Class<?> target, @NonNull List<Field> allFields, @NonNull ClassDesc targetClassDesc, @NonNull ClassDesc generatingClassDesc) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (allFields == null) {
            throw new NullPointerException("allFields is marked non-null but is null");
        }
        if (targetClassDesc == null) {
            throw new NullPointerException("targetClassDesc is marked non-null but is null");
        }
        if (generatingClassDesc == null) {
            throw new NullPointerException("generatingClassDesc is marked non-null but is null");
        }
        for (Field field : allFields) {
            if (field.getDeclaringClass() != target) continue;
            ClassDesc fieldTypeDesc = ClassDesc.ofDescriptor(field.getType().descriptorString());
            Method getterMethod = DataClassCodecGenerator.getAndValidateGetterMethod(field);
            if (getterMethod != null) {
                MethodTypeDesc getterMethodType = MethodTypeDesc.of(fieldTypeDesc);
                boolean getterInInterface = getterMethod.getDeclaringClass().isInterface();
                Opcode invocationOpcode = getterInInterface ? Opcode.INVOKEINTERFACE : Opcode.INVOKEVIRTUAL;
                code.aload(2).aload(1).aload(3).checkcast(targetClassDesc).invoke(invocationOpcode, targetClassDesc, getterMethod.getName(), getterMethodType, getterInInterface);
            } else {
                code.aload(2).aload(1).aload(3).checkcast(targetClassDesc).getfield(targetClassDesc, field.getName(), fieldTypeDesc);
            }
            if (fieldTypeDesc.isPrimitive()) {
                CodeGenerationUtil.boxPrimitive(code, fieldTypeDesc.descriptorString());
            }
            code.invokeinterface(CD_OBJECT_MAPPER, OBJECT_MAPPER_WRITE_NAME, MT_OBJECT_MAPPER_WRITE).pop();
        }
        code.aload(0).getfield(generatingClassDesc, SUPER_CODEC_NAME, CD_DATA_CLASS_CODEC).ifThen(Opcode.IFNONNULL, ifGuardedCode -> ifGuardedCode.aload(0).getfield(generatingClassDesc, SUPER_CODEC_NAME, CD_DATA_CLASS_CODEC).aload(1).aload(2).aload(3).invokeinterface(CD_DATA_CLASS_CODEC, SERIALIZE_METHOD_NAME, MT_SERIALIZE));
        code.return_();
    }

    private static void generateDeserializeMethod(@NonNull CodeBuilder code, @NonNull List<Field> allFields, @NonNull ClassDesc targetClassDesc, @NonNull ClassDesc generatingClassDesc) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (allFields == null) {
            throw new NullPointerException("allFields is marked non-null but is null");
        }
        if (targetClassDesc == null) {
            throw new NullPointerException("targetClassDesc is marked non-null but is null");
        }
        if (generatingClassDesc == null) {
            throw new NullPointerException("generatingClassDesc is marked non-null but is null");
        }
        int fieldCount = allFields.size();
        int[] parameterTypesStoreSlots = new int[fieldCount];
        ClassDesc[] constructorParamTypes = new ClassDesc[fieldCount];
        for (int index = 0; index < fieldCount; ++index) {
            Field field = allFields.get(index);
            ClassDesc fieldType = ClassDesc.ofDescriptor(field.getType().descriptorString());
            code.aload(2).aload(1).aload(0).getfield(generatingClassDesc, FIELDS_FIELD_NAME, CD_FIELD_ARRAY).ldc((ConstantDesc)Integer.valueOf(index)).aaload().invokevirtual(CD_FIELD, FIELD_GET_TYPE_NAME, MT_FIELD_GET_TYPE).invokeinterface(CD_OBJECT_MAPPER, OBJECT_MAPPER_READ_NAME, MT_OBJECT_MAPPER_READ);
            if (fieldType.isPrimitive()) {
                CodeGenerationUtil.unboxPrimitive(code, fieldType.descriptorString());
            } else {
                code.checkcast(fieldType);
            }
            TypeKind typeKind = TypeKind.fromDescriptor((CharSequence)fieldType.descriptorString());
            int parameterSlot = code.allocateLocal(typeKind);
            code.storeLocal(typeKind, parameterSlot);
            constructorParamTypes[index] = fieldType;
            parameterTypesStoreSlots[index] = parameterSlot;
        }
        code.new_(targetClassDesc).dup();
        MethodTypeDesc constructorMethodType = MethodTypeDesc.of(ConstantDescs.CD_void, constructorParamTypes);
        for (int index = 0; index < fieldCount; ++index) {
            ClassDesc type = constructorParamTypes[index];
            int storeSlot = parameterTypesStoreSlots[index];
            TypeKind typeKind = TypeKind.fromDescriptor((CharSequence)type.descriptorString());
            code.loadLocal(typeKind, storeSlot);
        }
        code.invokespecial(targetClassDesc, "<init>", constructorMethodType).areturn();
    }

    @Nullable
    private static Method getAndValidateGetterMethod(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        RPCFieldGetter getterAnnotation = field.getAnnotation(RPCFieldGetter.class);
        if (getterAnnotation == null) {
            return null;
        }
        try {
            Method getterMethod = field.getDeclaringClass().getDeclaredMethod(getterAnnotation.value(), new Class[0]);
            if (!field.getType().equals(getterMethod.getReturnType())) {
                throw new IllegalStateException(String.format("field %s in %s declared type %s but getter method %s returns %s", field.getName(), field.getDeclaringClass().getName(), field.getType().getName(), getterAnnotation.value(), getterMethod.getReturnType().getName()));
            }
            return getterMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(String.format("field %s in %s declared non-existing getter method %s", field.getName(), field.getDeclaringClass().getName(), getterAnnotation.value()));
        }
    }
}

