/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufable;
import eu.cloudnetservice.driver.network.rpc.defaults.object.data.DataClassSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.CollectionObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.DataBufObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.DataBufableObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.DocumentObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.EnumObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.FunctionalObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.MapObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.OptionalObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.PathObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.PatternObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.TimeObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.UUIDObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.exception.MissingObjectSerializerException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TransferQueue;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Provides(value={ObjectMapper.class})
public class DefaultObjectMapper
implements ObjectMapper {
    public static final ObjectMapper DEFAULT_MAPPER;
    private static final Map<Type, ObjectSerializer<?>> DEFAULT_SERIALIZERS;
    private final Map<Type, ObjectSerializer<?>> registeredSerializers = new ConcurrentHashMap();
    private final LoadingCache<Type, Collection<Tuple2<Type, Type>>> typeCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofDays(1L)).scheduler(Scheduler.systemScheduler()).build(key -> {
        ArrayList types = new ArrayList();
        for (TypeToken type : TypeToken.of(key).getTypes()) {
            types.add(new Tuple2(type.getType(), type.getRawType()));
        }
        return types;
    });

    public DefaultObjectMapper() {
        this(true);
    }

    public DefaultObjectMapper(boolean registerDefaultSerializers) {
        if (registerDefaultSerializers) {
            this.registeredSerializers.putAll(DEFAULT_SERIALIZERS);
        }
    }

    @Override
    @NonNull
    public ObjectMapper unregisterBinding(@NonNull Type type, boolean superTypes) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (superTypes) {
            Collection<Tuple2<Type, Type>> subTypes = this.typeCache.get(type);
            for (Tuple2<Type, Type> subType : subTypes) {
                this.registeredSerializers.remove(subType.first());
                this.registeredSerializers.remove(subType.second());
            }
        } else {
            this.registeredSerializers.remove(type);
        }
        return this;
    }

    @Override
    @NonNull
    public ObjectMapper unregisterBindings(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        for (Map.Entry<Type, ObjectSerializer<?>> entry : this.registeredSerializers.entrySet()) {
            if (!entry.getValue().getClass().getClassLoader().equals(classLoader)) continue;
            this.registeredSerializers.remove(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    @NonNull
    public <T> ObjectMapper registerBinding(@NonNull Type type, @NonNull ObjectSerializer<T> serializer, boolean superTypes) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (superTypes) {
            Collection<Tuple2<Type, Type>> subTypes = this.typeCache.get(type);
            for (Tuple2<Type, Type> subType : subTypes) {
                this.registeredSerializers.putIfAbsent(subType.first(), serializer);
                this.registeredSerializers.putIfAbsent(subType.second(), serializer);
            }
        } else {
            this.registeredSerializers.putIfAbsent(type, serializer);
        }
        return this;
    }

    @Override
    @NonNull
    public <T> DataBuf.Mutable writeObject(@NonNull DataBuf.Mutable dataBuf, @Nullable T object) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        return dataBuf.writeNullable(object, (buffer, obj) -> {
            Tuple2<Type, Type> subType;
            Collection<Tuple2<Type, Type>> subTypes = this.typeCache.get(obj.getClass());
            ObjectSerializer<Object> serializer = null;
            Iterator<Tuple2<Type, Type>> iterator = subTypes.iterator();
            while (iterator.hasNext() && ((serializer = this.serializerForType(subType = iterator.next())) == null || !serializer.preWriteCheckAccepts(obj, this))) {
            }
            if (serializer == null || !serializer.preWriteCheckAccepts(obj, this)) {
                throw new MissingObjectSerializerException(obj.getClass());
            }
            serializer.write((DataBuf.Mutable)buffer, obj, obj.getClass(), this);
        });
    }

    @Override
    @Nullable
    public <T> T readObject(@NonNull DataBuf dataBuf, @NonNull Type type) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)dataBuf.readNullable(buffer -> {
            Tuple2<Type, Type> subType;
            Collection<Tuple2<Type, Type>> subTypes = this.typeCache.get(type);
            ObjectSerializer serializer = null;
            Iterator<Tuple2<Type, Type>> iterator = subTypes.iterator();
            while (iterator.hasNext() && ((serializer = this.serializerForType(subType = iterator.next())) == null || !serializer.preReadCheckAccepts(type, this))) {
            }
            if (serializer == null || !serializer.preReadCheckAccepts(type, this)) {
                throw new MissingObjectSerializerException(type);
            }
            return serializer.read((DataBuf)buffer, type, this);
        });
    }

    @Nullable
    protected <T> ObjectSerializer<T> serializerForType(@NonNull Tuple2<Type, Type> typePair) {
        if (typePair == null) {
            throw new NullPointerException("typePair is marked non-null but is null");
        }
        ObjectSerializer<?> byType = this.registeredSerializers.get(typePair.first());
        return byType == null ? this.registeredSerializers.get(typePair.second()) : byType;
    }

    static {
        DEFAULT_SERIALIZERS = ImmutableMap.builder().put(Boolean.TYPE, FunctionalObjectSerializer.of(DataBuf::readBoolean, DataBuf.Mutable::writeBoolean)).put(Boolean.class, FunctionalObjectSerializer.of(DataBuf::readBoolean, DataBuf.Mutable::writeBoolean)).put(Byte.TYPE, FunctionalObjectSerializer.of(DataBuf::readByte, DataBuf.Mutable::writeByte)).put(Byte.class, FunctionalObjectSerializer.of(DataBuf::readByte, DataBuf.Mutable::writeByte)).put(Short.TYPE, FunctionalObjectSerializer.of(DataBuf::readShort, DataBuf.Mutable::writeShort)).put(Short.class, FunctionalObjectSerializer.of(DataBuf::readShort, DataBuf.Mutable::writeShort)).put(Integer.TYPE, FunctionalObjectSerializer.of(DataBuf::readInt, DataBuf.Mutable::writeInt)).put(Integer.class, FunctionalObjectSerializer.of(DataBuf::readInt, DataBuf.Mutable::writeInt)).put(Long.TYPE, FunctionalObjectSerializer.of(DataBuf::readLong, DataBuf.Mutable::writeLong)).put(Long.class, FunctionalObjectSerializer.of(DataBuf::readLong, DataBuf.Mutable::writeLong)).put(Float.TYPE, FunctionalObjectSerializer.of(DataBuf::readFloat, DataBuf.Mutable::writeFloat)).put(Float.class, FunctionalObjectSerializer.of(DataBuf::readFloat, DataBuf.Mutable::writeFloat)).put(Double.TYPE, FunctionalObjectSerializer.of(DataBuf::readDouble, DataBuf.Mutable::writeDouble)).put(Double.class, FunctionalObjectSerializer.of(DataBuf::readDouble, DataBuf.Mutable::writeDouble)).put(Character.TYPE, FunctionalObjectSerializer.of(DataBuf::readChar, DataBuf.Mutable::writeChar)).put(Character.class, FunctionalObjectSerializer.of(DataBuf::readChar, DataBuf.Mutable::writeChar)).put(String.class, FunctionalObjectSerializer.of(DataBuf::readString, DataBuf.Mutable::writeString)).put(byte[].class, FunctionalObjectSerializer.of(DataBuf::readByteArray, DataBuf.Mutable::writeByteArray)).put(UUID.class, (FunctionalObjectSerializer<byte[]>)((Object)new UUIDObjectSerializer())).put(Pattern.class, (FunctionalObjectSerializer<byte[]>)((Object)new PatternObjectSerializer())).put(Optional.class, (FunctionalObjectSerializer<byte[]>)((Object)new OptionalObjectSerializer())).put(Vector.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(Vector::new))).put(List.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(ArrayList::new))).put(Deque.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(ArrayDeque::new))).put(Set.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(HashSet::newHashSet))).put(Stack.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new Stack()))).put(Collection.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(ArrayList::new))).put(Queue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new LinkedList()))).put(SortedSet.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new TreeSet()))).put(PriorityQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(PriorityQueue::new))).put(BlockingQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(ArrayBlockingQueue::new))).put(LinkedHashSet.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(LinkedHashSet::newLinkedHashSet))).put(TransferQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new LinkedTransferQueue()))).put(SynchronousQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new SynchronousQueue()))).put(PriorityBlockingQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(PriorityBlockingQueue::new))).put(LinkedBlockingQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new LinkedBlockingQueue()))).put(LinkedBlockingDeque.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new LinkedBlockingDeque()))).put(CopyOnWriteArraySet.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new CopyOnWriteArraySet()))).put(CopyOnWriteArrayList.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new CopyOnWriteArrayList()))).put(ConcurrentSkipListSet.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new ConcurrentSkipListSet()))).put(ConcurrentLinkedDeque.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new ConcurrentLinkedDeque()))).put(ConcurrentLinkedQueue.class, (FunctionalObjectSerializer<byte[]>)((Object)CollectionObjectSerializer.of(n -> new ConcurrentLinkedQueue()))).put(Map.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(HashMap::newHashMap))).put(Hashtable.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(Hashtable::new))).put(Properties.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(Properties::new))).put(NavigableMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(n -> new TreeMap()))).put(ConcurrentMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(ConcurrentHashMap::new))).put(IdentityHashMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(IdentityHashMap::new))).put(WeakHashMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(WeakHashMap::newWeakHashMap))).put(LinkedHashMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(LinkedHashMap::newLinkedHashMap))).put(ConcurrentNavigableMap.class, (FunctionalObjectSerializer<byte[]>)((Object)MapObjectSerializer.of(n -> new ConcurrentSkipListMap()))).put((Class<ConcurrentNavigableMap>)Year.class, (FunctionalObjectSerializer<byte[]>)TimeObjectSerializer.YEAR_SERIALIZER).put(Period.class, TimeObjectSerializer.PERIOD_SERIALIZER).put(ZoneId.class, TimeObjectSerializer.ZONE_ID_SERIALIZER).put(Instant.class, TimeObjectSerializer.INSTANT_SERIALIZER).put(Duration.class, TimeObjectSerializer.DURATION_SERIALIZER).put(MonthDay.class, TimeObjectSerializer.MONTH_DAY_SERIALIZER).put(LocalDate.class, TimeObjectSerializer.LOCAL_DATE_SERIALIZER).put(LocalTime.class, TimeObjectSerializer.LOCAL_TIME_SERIALIZER).put(YearMonth.class, TimeObjectSerializer.YEAR_MONTH_SERIALIZER).put(OffsetTime.class, TimeObjectSerializer.OFFSET_TIME_SERIALIZER).put(LocalDateTime.class, TimeObjectSerializer.LOCAL_DATE_TIME_SERIALIZER).put(ZonedDateTime.class, TimeObjectSerializer.ZONED_DATE_TIME_SERIALIZER).put(OffsetDateTime.class, TimeObjectSerializer.OFFSET_DATE_TIME_SERIALIZER).put(Path.class, new PathObjectSerializer()).put(DataBuf.class, new DataBufObjectSerializer()).put(DataBufable.class, new DataBufableObjectSerializer()).put(Document.class, new DocumentObjectSerializer()).put(Enum.class, new EnumObjectSerializer()).put(Object.class, new DataClassSerializer()).build();
        DEFAULT_MAPPER = new DefaultObjectMapper();
    }
}

