/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvoker;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvokerGenerator;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.handler.RPCInvocationContext;
import eu.cloudnetservice.driver.network.rpc.handler.RPCInvocationResult;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import io.vavr.control.Try;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRPCHandler
extends DefaultRPCProvider
implements RPCHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRPCHandler.class);
    private final Object boundInstance;
    private final RPCClassMetadata targetClassMeta;
    private final Cache<RPCMethodMetadata, MethodInvoker> methodInvokerCache;

    DefaultRPCHandler(@NonNull RPCFactory sourceFactory, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory, @Nullable Object boundInstance, @NonNull RPCClassMetadata targetClassMeta) {
        super(targetClassMeta.targetClass(), sourceFactory, objectMapper, dataBufFactory);
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (targetClassMeta == null) {
            throw new NullPointerException("targetClassMeta is marked non-null but is null");
        }
        this.boundInstance = boundInstance;
        this.targetClassMeta = targetClassMeta;
        this.methodInvokerCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofDays(1L)).build();
    }

    @Nullable
    private static MethodTypeDesc parseMethodDescriptor(@NonNull String descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        try {
            return MethodTypeDesc.ofDescriptor(descriptor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NonNull
    public CompletableFuture<RPCInvocationResult> handle(@NonNull RPCInvocationContext context) {
        Object workingInstance;
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Object contextualInstance = context.workingInstance();
        Object object = workingInstance = contextualInstance != null ? contextualInstance : this.boundInstance;
        if (workingInstance == null) {
            return TaskUtil.finishedFuture(new RPCInvocationResult.ServerError("no instance to invoke the method on", this));
        }
        MethodTypeDesc targetMethodType = DefaultRPCHandler.parseMethodDescriptor(context.methodDescriptor());
        if (targetMethodType == null) {
            return TaskUtil.finishedFuture(new RPCInvocationResult.BadRequest("invalid target method descriptor", this));
        }
        RPCMethodMetadata targetMethod = this.targetClassMeta.findMethod(context.methodName(), targetMethodType);
        if (targetMethod == null) {
            return TaskUtil.finishedFuture(new RPCInvocationResult.BadRequest("target method not found", this));
        }
        Object[] methodArguments = this.deserializeMethodArguments(targetMethod, context.argumentInformation());
        if (methodArguments == null) {
            String targetDescriptor = targetMethod.methodType().descriptorString();
            String msg = String.format("provided arguments do not satisfy %s", targetDescriptor);
            return TaskUtil.finishedFuture(new RPCInvocationResult.BadRequest(msg, this));
        }
        Try<MethodInvoker> maybeMethodInvoker = this.getOrCreateMethodInvoker(targetMethod);
        if (maybeMethodInvoker.isFailure()) {
            Throwable constructionException = maybeMethodInvoker.getCause();
            LOGGER.error("unable to create method invoker for {}", (Object)targetMethod, (Object)constructionException);
            return TaskUtil.finishedFuture(new RPCInvocationResult.ServerError("unable to create method invoker", this));
        }
        try {
            MethodInvoker methodInvoker = maybeMethodInvoker.get();
            Object invocationResult = methodInvoker.callMethod(workingInstance, methodArguments);
            if (invocationResult instanceof Future) {
                Future future;
                Future future2 = future = (Future)invocationResult;
                Objects.requireNonNull(future2);
                Future future3 = future2;
                int n = 0;
                CompletableFuture<Object> futureCompletionStage = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompletionStage.class, Future.class}, (Future)future3, n)) {
                    case 0 -> {
                        CompletableFuture<Object> stage;
                        yield stage = (CompletableFuture<Object>)future3;
                    }
                    default -> {
                        Future rawFuture = future3;
                        yield CompletableFuture.supplyAsync(() -> {
                            try {
                                return rawFuture.get();
                            }
                            catch (InterruptedException exception) {
                                Thread.currentThread().interrupt();
                                throw new CompletionException("interrupt", exception);
                            }
                            catch (ExecutionException exception) {
                                throw new CompletionException(exception);
                            }
                        });
                    }
                };
                CompletableFuture<RPCInvocationResult> resultTask = new CompletableFuture<RPCInvocationResult>();
                futureCompletionStage.whenComplete((futureResult, exception) -> {
                    if (exception != null) {
                        resultTask.complete(new RPCInvocationResult.Failure((Throwable)exception, this, targetMethod));
                    } else {
                        resultTask.complete(new RPCInvocationResult.Success(futureResult, this, targetMethod));
                    }
                });
                return resultTask;
            }
            return TaskUtil.finishedFuture(new RPCInvocationResult.Success(invocationResult, this, targetMethod));
        }
        catch (Throwable throwable) {
            return TaskUtil.finishedFuture(new RPCInvocationResult.Failure(throwable, this, targetMethod));
        }
    }

    @NonNull
    private Try<MethodInvoker> getOrCreateMethodInvoker(@NonNull RPCMethodMetadata methodMetadata) {
        if (methodMetadata == null) {
            throw new NullPointerException("methodMetadata is marked non-null but is null");
        }
        return Try.of(() -> this.methodInvokerCache.get(methodMetadata, MethodInvokerGenerator::makeMethodInvoker));
    }

    @Nullable
    private Object[] deserializeMethodArguments(@NonNull RPCMethodMetadata targetMethod, @NonNull DataBuf encodedArgumentsBuffer) {
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (encodedArgumentsBuffer == null) {
            throw new NullPointerException("encodedArgumentsBuffer is marked non-null but is null");
        }
        try {
            Type[] paramTypes = targetMethod.parameterTypes();
            Object[] methodArguments = new Object[paramTypes.length];
            for (int index = 0; index < paramTypes.length; ++index) {
                Class clazz;
                Type parameterType = paramTypes[index];
                Object parameterValue = this.objectMapper.readObject(encodedArgumentsBuffer, parameterType);
                if (parameterType instanceof Class && (clazz = (Class)parameterType).isPrimitive() && parameterValue == null) {
                    return null;
                }
                methodArguments[index] = parameterValue;
            }
            return methodArguments;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

