/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCInvocationTarget;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.BasicRPCMethodGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.ChainedRPCMethodGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationConstants;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCMethodGenerator;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.util.CodeGenerationUtil;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Opcode;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

final class RPCImplementationGenerator {
    static final int FLAG_IMPLEMENT_CONCRETE = 1;
    private static final RPCMethodGenerator BASIC_GENERATOR = new BasicRPCMethodGenerator();
    private static final RPCMethodGenerator CHAINED_GENERATOR = new ChainedRPCMethodGenerator();
    private final int generationFlags;
    private final RPCClassMetadata targetClassMeta;
    private final ClassDesc generatingClass;
    private final RPCGenerationContext context;

    RPCImplementationGenerator(@NonNull RPCGenerationContext context, @NonNull RPCClassMetadata targetClassMeta, int generationFlags) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targetClassMeta == null) {
            throw new NullPointerException("targetClassMeta is marked non-null but is null");
        }
        this.targetClassMeta = targetClassMeta;
        this.generationFlags = generationFlags;
        this.context = context;
        ClassDesc targetClassDesc = ClassDesc.of(targetClassMeta.targetClass().getName());
        this.generatingClass = targetClassDesc.nested("RPC_BRIDGE");
    }

    static void generateObjectArgumentStore(@NonNull CodeBuilder codeBuilder, @NonNull MethodType methodType) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (methodType == null) {
            throw new NullPointerException("methodType is marked non-null but is null");
        }
        int paramCount = methodType.parameterCount();
        codeBuilder.ldc((ConstantDesc)Integer.valueOf(paramCount)).anewarray(ConstantDescs.CD_Object);
        for (int index = 0; index < paramCount; ++index) {
            TypeDescriptor.OfField paramType = methodType.parameterType(index);
            int parameterSlot = codeBuilder.parameterSlot(index);
            if (((Class)paramType).isPrimitive()) {
                String descriptor = ((Class)paramType).descriptorString();
                TypeKind typeKind = TypeKind.fromDescriptor((CharSequence)descriptor);
                codeBuilder.dup().ldc((ConstantDesc)Integer.valueOf(index)).loadLocal(typeKind, parameterSlot);
                CodeGenerationUtil.boxPrimitive(codeBuilder, descriptor);
                codeBuilder.aastore();
                continue;
            }
            codeBuilder.dup().ldc((ConstantDesc)Integer.valueOf(index)).aload(parameterSlot).aastore();
        }
    }

    @NonNull
    public MethodHandles.Lookup generateImplementation() {
        Tuple2<ClassDesc, MethodTypeDesc> baseConstructorInformation = this.resolveBaseConstructorInformation();
        this.context.superclassConstructorDesc = baseConstructorInformation.second();
        byte[] classFileBytes = ClassFile.of().build(this.generatingClass, classBuilder -> {
            Class<?> targetClass = this.targetClassMeta.targetClass();
            ClassDesc superDesc = ClassDesc.of(targetClass.getName());
            if (targetClass.isInterface()) {
                classBuilder.withInterfaceSymbols(new ClassDesc[]{superDesc});
            } else {
                classBuilder.withSuperclass(superDesc);
            }
            classBuilder.withField("rpc_sender", RPCGenerationConstants.CD_RPC_SENDER, RPCGenerationConstants.AFM_FIELD_PF);
            classBuilder.withField("base_rpc", RPCGenerationConstants.CD_CHAINABLE_RPC, RPCGenerationConstants.AFM_FIELD_PF);
            classBuilder.withField("channel_supplier", RPCGenerationConstants.CD_SUPPLIER, RPCGenerationConstants.AFM_FIELD_PF);
            this.generateBridgeRPCInvokeMethod((ClassBuilder)classBuilder);
            this.generateBridgeChannelGetterMethod((ClassBuilder)classBuilder);
            Collection<RPCMethodMetadata> methods = this.targetClassMeta.methods();
            for (RPCMethodMetadata method : methods) {
                if (method.concrete() && !this.flagEnabled(1)) continue;
                String methodDescriptorString = method.methodType().descriptorString();
                MethodTypeDesc methodDescriptor = MethodTypeDesc.ofDescriptor(methodDescriptorString);
                classBuilder.withMethodBody(method.name(), methodDescriptor, 1, code -> {
                    RPCMethodMetadata.MethodChainMetadata chainMeta = method.chainMetadata();
                    if (chainMeta == null) {
                        BASIC_GENERATOR.generate((CodeBuilder)code, this.generatingClass, this.context, method, methodDescriptor);
                    } else {
                        CHAINED_GENERATOR.generate((CodeBuilder)code, this.generatingClass, this.context, method, methodDescriptor);
                    }
                });
            }
            this.generateConstructor((ClassBuilder)classBuilder, (ClassDesc)baseConstructorInformation.first(), (MethodTypeDesc)baseConstructorInformation.second());
        });
        return CodeGenerationUtil.defineNestedClass(this.targetClassMeta.targetClass(), classFileBytes);
    }

    private boolean flagEnabled(int flag) {
        return (this.generationFlags & flag) != 0;
    }

    @NonNull
    private Tuple2<ClassDesc, MethodTypeDesc> resolveBaseConstructorInformation() {
        Constructor<?>[] constructors;
        Class<?> targetClass = this.targetClassMeta.targetClass();
        if (targetClass.isInterface()) {
            return new Tuple2<ClassDesc, MethodTypeDesc>(ConstantDescs.CD_Object, RPCGenerationConstants.MTD_NO_ARGS_CONSTRUCTOR);
        }
        ClassDesc superClassDesc = ClassDesc.of(targetClass.getName());
        for (Constructor<?> constructor : constructors = targetClass.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(RPCInvocationTarget.class)) continue;
            Class<?>[] constructorParamTypes = constructor.getParameterTypes();
            List<ClassDesc> paramTypeDescriptors = Arrays.stream(constructorParamTypes).map(paramType -> ClassDesc.ofDescriptor(paramType.descriptorString())).toList();
            MethodTypeDesc constructorMethodDescriptor = MethodTypeDesc.of(ConstantDescs.CD_void, paramTypeDescriptors);
            return new Tuple2<ClassDesc, MethodTypeDesc>(superClassDesc, constructorMethodDescriptor);
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            return new Tuple2<ClassDesc, MethodTypeDesc>(superClassDesc, RPCGenerationConstants.MTD_NO_ARGS_CONSTRUCTOR);
        }
        throw new IllegalStateException(String.format("no target constructor for rpc found in %s", targetClass.getName()));
    }

    private void generateBridgeRPCInvokeMethod(@NonNull ClassBuilder classBuilder) {
        if (classBuilder == null) {
            throw new NullPointerException("classBuilder is marked non-null but is null");
        }
        classBuilder.withMethodBody("bridge$rpc$invoke", RPCGenerationConstants.MTD_BRIDGE_RPC_INVOKE, 2, code -> {
            int baseRPCStoreSlot = code.allocateLocal(TypeKind.ReferenceType);
            code.aload(0).getfield(this.generatingClass, "rpc_sender", RPCGenerationConstants.CD_RPC_SENDER).aload(1).aload(2).aload(3).invokeinterface(RPCGenerationConstants.CD_RPC_SENDER, "invokeMethod", RPCGenerationConstants.MTD_RPC_INVOKE).astore(baseRPCStoreSlot).aload(0).getfield(this.generatingClass, "base_rpc", RPCGenerationConstants.CD_CHAINABLE_RPC).ifThenElse(Opcode.IFNULL, ifNullCode -> ifNullCode.aload(baseRPCStoreSlot).areturn(), ifNonNullCode -> ifNonNullCode.aload(0).getfield(this.generatingClass, "base_rpc", RPCGenerationConstants.CD_CHAINABLE_RPC).aload(baseRPCStoreSlot).invokeinterface(RPCGenerationConstants.CD_CHAINABLE_RPC, "join", RPCGenerationConstants.MTD_RPC_JOIN).areturn());
        });
    }

    private void generateBridgeChannelGetterMethod(@NonNull ClassBuilder classBuilder) {
        if (classBuilder == null) {
            throw new NullPointerException("classBuilder is marked non-null but is null");
        }
        classBuilder.withMethodBody("bridge$rpc$target_channel", RPCGenerationConstants.MTD_BRIDGE_GET_CHANNEL, 2, code -> code.aload(0).getfield(this.generatingClass, "channel_supplier", RPCGenerationConstants.CD_SUPPLIER).invokeinterface(RPCGenerationConstants.CD_SUPPLIER, "get", RPCGenerationConstants.MTD_SUPPLIER_GET).checkcast(RPCGenerationConstants.CD_NETWORK_CHANNEL).areturn());
    }

    private void generateConstructor(@NonNull ClassBuilder classBuilder, @NonNull ClassDesc superClass, @NonNull MethodTypeDesc superConstructorDesc) {
        if (classBuilder == null) {
            throw new NullPointerException("classBuilder is marked non-null but is null");
        }
        if (superClass == null) {
            throw new NullPointerException("superClass is marked non-null but is null");
        }
        if (superConstructorDesc == null) {
            throw new NullPointerException("superConstructorDesc is marked non-null but is null");
        }
        int instanceFactoryCount = this.context.additionalInstanceFactoryCount();
        Object[] instanceFactoryParamTypes = new ClassDesc[instanceFactoryCount];
        Arrays.fill(instanceFactoryParamTypes, RPCGenerationConstants.CD_INT_INSTANCE_FACTORY);
        MethodTypeDesc baseConstructorMethodType = RPCInternalInstanceFactory.MTD_BASIC_IMPLEMENTATION_CONSTRUCTOR;
        MethodTypeDesc constructorMethodType = baseConstructorMethodType.insertParameterTypes(baseConstructorMethodType.parameterCount(), (ClassDesc[])instanceFactoryParamTypes);
        classBuilder.withMethodBody("<init>", constructorMethodType, 1, code -> {
            code.aload(0).aload(1).putfield(this.generatingClass, "channel_supplier", RPCGenerationConstants.CD_SUPPLIER).aload(0).aload(2).putfield(this.generatingClass, "rpc_sender", RPCGenerationConstants.CD_RPC_SENDER).aload(0).aload(3).putfield(this.generatingClass, "base_rpc", RPCGenerationConstants.CD_CHAINABLE_RPC);
            this.context.applyToClassAndConstructor(this.generatingClass, classBuilder, (CodeBuilder)code);
            code.aload(0);
            int superConstructorParamCount = superConstructorDesc.parameterCount();
            for (int index = 0; index < superConstructorParamCount; ++index) {
                code.aload(4).ldc((ConstantDesc)Integer.valueOf(index)).aaload();
                ClassDesc superConstructorParamType = superConstructorDesc.parameterType(index);
                if (superConstructorParamType.isPrimitive()) {
                    CodeGenerationUtil.unboxPrimitive(code, superConstructorParamType.descriptorString());
                    continue;
                }
                code.checkcast(superConstructorParamType);
            }
            code.invokespecial(superClass, "<init>", superConstructorDesc).return_();
        });
    }
}

