/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.sender.DefaultRPCSender;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RPCGenerationCache {
    private final Cache<CacheKey, RPCInternalInstanceFactory> cachedGeneratedImplementation = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(8L)).build();
    private final DefaultRPCFactory rpcFactory;

    public RPCGenerationCache(@NonNull DefaultRPCFactory rpcFactory) {
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        this.rpcFactory = rpcFactory;
    }

    @NonNull
    RPCInternalInstanceFactory getOrGenerateImplementation(int generationFlags, @NonNull Class<?> senderTargetType, @NonNull RPCClassMetadata baseClassMeta) {
        if (senderTargetType == null) {
            throw new NullPointerException("senderTargetType is marked non-null but is null");
        }
        if (baseClassMeta == null) {
            throw new NullPointerException("baseClassMeta is marked non-null but is null");
        }
        DefaultRPCSender sender = new DefaultRPCSender(senderTargetType, this.rpcFactory, this.rpcFactory.defaultObjectMapper(), this.rpcFactory.defaultDataBufFactory(), baseClassMeta, () -> null);
        return this.getOrGenerateImplementation(generationFlags, sender, baseClassMeta);
    }

    @NonNull
    public RPCInternalInstanceFactory getOrGenerateImplementation(int generationFlags, @NonNull RPCSender rpcSender, @NonNull RPCClassMetadata baseClassMeta) {
        if (rpcSender == null) {
            throw new NullPointerException("rpcSender is marked non-null but is null");
        }
        if (baseClassMeta == null) {
            throw new NullPointerException("baseClassMeta is marked non-null but is null");
        }
        Class<?> generationTargetClass = baseClassMeta.targetClass();
        CacheKey generationTargetCacheKey = new CacheKey(generationFlags, generationTargetClass);
        RPCInternalInstanceFactory existingImplementation = this.cachedGeneratedImplementation.getIfPresent(generationTargetCacheKey);
        if (existingImplementation != null) {
            return existingImplementation;
        }
        RPCInternalInstanceFactory.TempRPCInternalInstanceFactory tempInstanceFactory = new RPCInternalInstanceFactory.TempRPCInternalInstanceFactory();
        this.cachedGeneratedImplementation.put(generationTargetCacheKey, tempInstanceFactory);
        RPCGenerationContext context = new RPCGenerationContext(this);
        RPCImplementationGenerator rpcGenerator = new RPCImplementationGenerator(context, baseClassMeta, generationFlags);
        MethodHandles.Lookup generatedClassLookup = rpcGenerator.generateImplementation();
        int userArgCount = context.superclassConstructorDesc.parameterCount();
        RPCInternalInstanceFactory[] additionalInstanceFactories = (RPCInternalInstanceFactory[])context.additionalInstanceFactories().toArray(RPCInternalInstanceFactory[]::new);
        RPCInternalInstanceFactory instanceFactory = RPCInternalInstanceFactory.make(userArgCount, generatedClassLookup, () -> this.cachedGeneratedImplementation.getIfPresent(generationTargetCacheKey), rpcSender, additionalInstanceFactories);
        this.cachedGeneratedImplementation.put(generationTargetCacheKey, instanceFactory);
        tempInstanceFactory.setDelegate(instanceFactory);
        return instanceFactory;
    }

    private record CacheKey(int generationFlags, @NonNull Class<?> targetClass) {
        @Generated
        public CacheKey(int generationFlags, @NonNull Class<?> targetClass) {
            if (targetClass == null) {
                throw new NullPointerException("targetClass is marked non-null but is null");
            }
        }
    }
}

