/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.ChainableRPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationCache;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.sender.DefaultRPCSender;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCImplementationBuilder;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRPCImplementationBuilder<T>
implements RPCImplementationBuilder<T> {
    private final RPCFactory sourceFactory;
    private final RPCClassMetadata classMetadata;
    private final RPCClassMetadata fullClasMetadata;
    private final RPCGenerationCache generationCache;
    private int generationFlags = 0;
    private ObjectMapper objectMapper;
    private Class<?> senderTargetClass;
    private DataBufFactory dataBufFactory;
    private Supplier<NetworkChannel> channelSupplier;

    public DefaultRPCImplementationBuilder(@NonNull RPCFactory sourceFactory, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory, @NonNull RPCClassMetadata classMetadata, @NonNull RPCGenerationCache generationCache) {
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (classMetadata == null) {
            throw new NullPointerException("classMetadata is marked non-null but is null");
        }
        if (generationCache == null) {
            throw new NullPointerException("generationCache is marked non-null but is null");
        }
        this.sourceFactory = sourceFactory;
        this.classMetadata = classMetadata;
        this.fullClasMetadata = classMetadata.freeze();
        this.generationCache = generationCache;
        this.objectMapper = objectMapper;
        this.dataBufFactory = dataBufFactory;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> superclass(@NonNull Class<? super T> superclass) {
        if (superclass == null) {
            throw new NullPointerException("superclass is marked non-null but is null");
        }
        Preconditions.checkArgument(superclass.isAssignableFrom(this.classMetadata.targetClass()));
        this.senderTargetClass = superclass;
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> targetComponent(@NonNull NetworkComponent networkComponent) {
        if (networkComponent == null) {
            throw new NullPointerException("networkComponent is marked non-null but is null");
        }
        return this.targetChannel(networkComponent::firstChannel);
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> targetChannel(@NonNull NetworkChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.targetChannel(() -> channel);
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> targetChannel(@NonNull Supplier<NetworkChannel> channelSupplier) {
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.channelSupplier = channelSupplier;
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> implementConcreteMethods() {
        this.generationFlags |= 1;
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> excludeMethod(@NonNull String name, @NonNull TypeDescriptor methodDescriptor) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor is marked non-null but is null");
        }
        this.classMetadata.unregisterMethod(name, methodDescriptor);
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> objectMapper(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder<T> dataBufFactory(@NonNull DataBufFactory dataBufFactory) {
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.dataBufFactory = dataBufFactory;
        return this;
    }

    @Override
    @NonNull
    public RPCImplementationBuilder.InstanceAllocator<T> generateImplementation() {
        Preconditions.checkState(this.channelSupplier != null, "channel supplier must be given");
        RPCClassMetadata classMeta = this.classMetadata.freeze();
        Class<?> senderTarget = Objects.requireNonNullElse(this.senderTargetClass, classMeta.targetClass());
        DefaultRPCSender sender = new DefaultRPCSender(senderTarget, this.sourceFactory, this.objectMapper, this.dataBufFactory, classMeta, () -> null);
        RPCInternalInstanceFactory factory = this.generationCache.getOrGenerateImplementation(this.generationFlags, sender, this.fullClasMetadata);
        return new DefaultInstanceAllocator(null, sender, this.channelSupplier, new Object[0], factory);
    }

    private record DefaultInstanceAllocator<T>(@Nullable ChainableRPC baseRPC, @NonNull RPCSender classRPCSender, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorParameters, @NonNull RPCInternalInstanceFactory internalInstanceFactory) implements RPCImplementationBuilder.InstanceAllocator<T>
    {
        @Generated
        public DefaultInstanceAllocator(@Nullable ChainableRPC baseRPC, @NonNull RPCSender classRPCSender, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorParameters, @NonNull RPCInternalInstanceFactory internalInstanceFactory) {
            if (classRPCSender == null) {
                throw new NullPointerException("classRPCSender is marked non-null but is null");
            }
            if (channelSupplier == null) {
                throw new NullPointerException("channelSupplier is marked non-null but is null");
            }
            if (additionalConstructorParameters == null) {
                throw new NullPointerException("additionalConstructorParameters is marked non-null but is null");
            }
            if (internalInstanceFactory == null) {
                throw new NullPointerException("internalInstanceFactory is marked non-null but is null");
            }
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> withBaseRPC(@Nullable ChainableRPC baseRPC) {
            return new DefaultInstanceAllocator<T>(baseRPC, this.classRPCSender, this.channelSupplier, this.additionalConstructorParameters, this.internalInstanceFactory);
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> withTargetChannel(@NonNull Supplier<NetworkChannel> channelSupplier) {
            if (channelSupplier == null) {
                throw new NullPointerException("channelSupplier is marked non-null but is null");
            }
            return new DefaultInstanceAllocator<T>(this.baseRPC, this.classRPCSender, channelSupplier, this.additionalConstructorParameters, this.internalInstanceFactory);
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> withAdditionalConstructorParameters(Object ... additionalConstructorParams) {
            Objects.requireNonNull(additionalConstructorParams, "additionalConstructorParams");
            return new DefaultInstanceAllocator<T>(this.baseRPC, this.classRPCSender, this.channelSupplier, (Object[])additionalConstructorParams.clone(), this.internalInstanceFactory);
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> changeConstructorParameter(int index, Object newConstructorParameter) {
            if (this.additionalConstructorParameters[index] == newConstructorParameter) {
                return this;
            }
            Object[] constructorParams = (Object[])this.additionalConstructorParameters.clone();
            constructorParams[index] = newConstructorParameter;
            return new DefaultInstanceAllocator<T>(this.baseRPC, this.classRPCSender, this.channelSupplier, constructorParams, this.internalInstanceFactory);
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> insertConstructorParameters(int index, Object ... parameters) {
            int currentParamCount = this.additionalConstructorParameters.length;
            if (index < 0 || index > currentParamCount) {
                throw new IndexOutOfBoundsException(index);
            }
            int paramCountToInsert = parameters.length;
            if (paramCountToInsert == 0) {
                return this;
            }
            Object[] newParams = new Object[currentParamCount + paramCountToInsert];
            if (index > 0) {
                System.arraycopy(this.additionalConstructorParameters, 0, newParams, 0, index);
            }
            System.arraycopy(parameters, 0, newParams, index, paramCountToInsert);
            if (index < currentParamCount) {
                System.arraycopy(this.additionalConstructorParameters, index, newParams, index + paramCountToInsert, currentParamCount - index);
            }
            return new DefaultInstanceAllocator<T>(this.baseRPC, this.classRPCSender, this.channelSupplier, newParams, this.internalInstanceFactory);
        }

        @Override
        @NonNull
        public RPCImplementationBuilder.InstanceAllocator<T> appendConstructorParameters(Object ... parameters) {
            return this.insertConstructorParameters(this.additionalConstructorParameters.length, parameters);
        }

        @Override
        @NonNull
        public T allocate() {
            return (T)this.internalInstanceFactory.constructInstance(this.baseRPC, this.classRPCSender, this.channelSupplier, this.additionalConstructorParameters);
        }
    }
}

