/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationConstants;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCMethodGenerator;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.util.CodeGenerationUtil;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import lombok.NonNull;

final class BasicRPCMethodGenerator
implements RPCMethodGenerator {
    private static final MethodTypeDesc MTD_FIRE = MethodTypeDesc.of(RPCGenerationConstants.CD_COMPLETABLE_FUTURE, RPCGenerationConstants.CD_NETWORK_CHANNEL);
    private static final MethodTypeDesc MTD_FIRE_SYNC = MethodTypeDesc.of(ConstantDescs.CD_Object, RPCGenerationConstants.CD_NETWORK_CHANNEL);
    private static final MethodTypeDesc MTD_FIRE_AND_FORGET = MethodTypeDesc.of(ConstantDescs.CD_void, RPCGenerationConstants.CD_NETWORK_CHANNEL);

    BasicRPCMethodGenerator() {
    }

    @Override
    public void generate(@NonNull CodeBuilder codeBuilder, @NonNull ClassDesc generatingClass, @NonNull RPCGenerationContext context, @NonNull RPCMethodMetadata targetMethod, @NonNull MethodTypeDesc targetMethodDesc) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (generatingClass == null) {
            throw new NullPointerException("generatingClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (targetMethodDesc == null) {
            throw new NullPointerException("targetMethodDesc is marked non-null but is null");
        }
        String typeDescriptorFieldName = context.registerTypeDescriptorField(targetMethod);
        codeBuilder.aload(0).ldc((ConstantDesc)((Object)targetMethod.name())).aload(0).getfield(generatingClass, typeDescriptorFieldName, RPCGenerationConstants.CD_TYPE_DESC);
        RPCImplementationGenerator.generateObjectArgumentStore(codeBuilder, targetMethod.methodType());
        codeBuilder.invokevirtual(generatingClass, "bridge$rpc$invoke", RPCGenerationConstants.MTD_BRIDGE_RPC_INVOKE).aload(0).invokevirtual(generatingClass, "bridge$rpc$target_channel", RPCGenerationConstants.MTD_BRIDGE_GET_CHANNEL);
        if (targetMethod.executionResultIgnored()) {
            codeBuilder.invokeinterface(RPCGenerationConstants.CD_RPC_EXECUTABLE, "fireAndForget", MTD_FIRE_AND_FORGET);
            ClassDesc returnType = targetMethodDesc.returnType();
            TypeKind returnTypeKind = TypeKind.fromDescriptor((CharSequence)returnType.descriptorString());
            switch (returnTypeKind) {
                case VoidType: {
                    codeBuilder.return_();
                    break;
                }
                case LongType: {
                    codeBuilder.lconst_0().lreturn();
                    break;
                }
                case FloatType: {
                    codeBuilder.fconst_0().freturn();
                    break;
                }
                case DoubleType: {
                    codeBuilder.dconst_0().dreturn();
                    break;
                }
                case ReferenceType: {
                    codeBuilder.aconst_null().areturn();
                    break;
                }
                case ByteType: 
                case ShortType: 
                case IntType: 
                case BooleanType: 
                case CharType: {
                    codeBuilder.iconst_0().ireturn();
                }
            }
        } else if (targetMethod.asyncReturnType()) {
            codeBuilder.invokeinterface(RPCGenerationConstants.CD_RPC_EXECUTABLE, "fire", MTD_FIRE).areturn();
        } else {
            ClassDesc returnType = targetMethodDesc.returnType();
            codeBuilder.invokeinterface(RPCGenerationConstants.CD_RPC_EXECUTABLE, "fireSync", MTD_FIRE_SYNC);
            if (returnType.isPrimitive()) {
                TypeKind returnTypeKind = TypeKind.fromDescriptor((CharSequence)returnType.descriptorString());
                if (returnTypeKind == TypeKind.VoidType) {
                    codeBuilder.pop().return_();
                } else {
                    CodeGenerationUtil.unboxPrimitive(codeBuilder, returnType.descriptorString());
                    codeBuilder.return_(returnTypeKind);
                }
            } else {
                codeBuilder.checkcast(returnType).areturn();
            }
        }
    }
}

