/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults;

import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.DefaultRPCImplementationBuilder;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationCache;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.DefaultRPCHandlerBuilder;
import eu.cloudnetservice.driver.network.rpc.defaults.sender.DefaultRPCSenderBuilder;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCImplementationBuilder;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@Singleton
@Provides(value={RPCFactory.class})
public final class DefaultRPCFactory
implements RPCFactory {
    private final ObjectMapper defaultObjectMapper;
    private final DataBufFactory defaultDataBufFactory;
    private final RPCGenerationCache rpcGenerationCache;

    @Inject
    public DefaultRPCFactory(@NonNull ObjectMapper defaultObjectMapper, @NonNull DataBufFactory defaultDataBufFactory) {
        if (defaultObjectMapper == null) {
            throw new NullPointerException("defaultObjectMapper is marked non-null but is null");
        }
        if (defaultDataBufFactory == null) {
            throw new NullPointerException("defaultDataBufFactory is marked non-null but is null");
        }
        this.defaultObjectMapper = defaultObjectMapper;
        this.defaultDataBufFactory = defaultDataBufFactory;
        this.rpcGenerationCache = new RPCGenerationCache(this);
    }

    @Override
    @NonNull
    public RPCSender.Builder newRPCSenderBuilder(@NonNull Class<?> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        RPCClassMetadata classMetadata = RPCClassMetadata.introspect(target);
        return new DefaultRPCSenderBuilder(this, classMetadata, this.defaultDataBufFactory, this.defaultObjectMapper);
    }

    @Override
    public <T>  @NonNull RPCHandler.Builder<T> newRPCHandlerBuilder(@NonNull Class<T> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        RPCClassMetadata classMetadata = RPCClassMetadata.introspect(target);
        return new DefaultRPCHandlerBuilder(this, classMetadata, this.defaultObjectMapper, this.defaultDataBufFactory);
    }

    @Override
    @NonNull
    public <T> RPCImplementationBuilder<T> newRPCBasedImplementationBuilder(@NonNull Class<T> baseClass) {
        if (baseClass == null) {
            throw new NullPointerException("baseClass is marked non-null but is null");
        }
        RPCClassMetadata classMeta = RPCClassMetadata.introspect(baseClass);
        return new DefaultRPCImplementationBuilder(this, this.defaultObjectMapper, this.defaultDataBufFactory, classMeta, this.rpcGenerationCache);
    }

    @ApiStatus.Internal
    @NonNull
    public ObjectMapper defaultObjectMapper() {
        return this.defaultObjectMapper;
    }

    @ApiStatus.Internal
    @NonNull
    public DataBufFactory defaultDataBufFactory() {
        return this.defaultDataBufFactory;
    }
}

