/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.protocol.defaults;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class DefaultPacketListenerRegistry
implements PacketListenerRegistry {
    private final PacketListenerRegistry parent;
    private final Multimap<Integer, PacketListener> listeners;

    public DefaultPacketListenerRegistry() {
        this(null);
    }

    public DefaultPacketListenerRegistry(@Nullable PacketListenerRegistry parent) {
        this.parent = parent;
        this.listeners = Multimaps.newMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    }

    @Override
    @Nullable
    public PacketListenerRegistry parent() {
        return this.parent;
    }

    @Override
    public void addListener(int channel, @NonNull Class<? extends PacketListener> listenerClass) {
        if (listenerClass == null) {
            throw new NullPointerException("listenerClass is marked non-null but is null");
        }
        Preconditions.checkArgument(channel != -1, "Tried to register listeners to forbidden channel id -1");
        this.listeners.put(channel, InjectionLayer.findLayerOf(listenerClass).instance(listenerClass));
    }

    @Override
    public void addListener(int channel, @NonNull PacketListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Preconditions.checkArgument(channel != -1, "Tried to register listeners to forbidden channel id -1");
        this.listeners.put(channel, listener);
    }

    @Override
    public void removeListener(int channel, @NonNull PacketListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Collection<PacketListener> registeredListeners = this.listeners.get(channel);
        if (!registeredListeners.isEmpty()) {
            registeredListeners.remove(listener);
        }
    }

    @Override
    public void removeListeners(int channel) {
        this.listeners.removeAll(channel);
    }

    @Override
    public void removeListeners(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        for (Map.Entry<Integer, PacketListener> entry : this.listeners.entries()) {
            if (!entry.getValue().getClass().getClassLoader().equals(classLoader)) continue;
            this.listeners.remove(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasListeners(int channel) {
        return this.listeners.containsKey(channel);
    }

    @Override
    public void removeListeners() {
        this.listeners.clear();
    }

    @Override
    @NonNull
    public @UnmodifiableView Collection<Integer> channels() {
        return Collections.unmodifiableCollection(this.listeners.keySet());
    }

    @Override
    @NonNull
    public @UnmodifiableView Collection<PacketListener> listeners() {
        return this.listeners.values();
    }

    @Override
    @NonNull
    public @UnmodifiableView Map<Integer, Collection<PacketListener>> packetListeners() {
        return Collections.unmodifiableMap(this.listeners.asMap());
    }

    @Override
    public boolean handlePacket(@NonNull NetworkChannel channel, @NonNull Packet packet) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        boolean parentDidHandle = this.parent != null && this.parent.handlePacket(channel, packet);
        Collection<PacketListener> registeredListeners = this.listeners.get(packet.channel());
        if (registeredListeners.isEmpty()) {
            return parentDidHandle;
        }
        for (PacketListener listener : registeredListeners) {
            try {
                listener.handle(channel, packet);
            }
            catch (Exception exception) {
                throw new IllegalStateException(String.format("Exception posting packet from channel %d to handler %s", packet.channel(), listener.getClass().getCanonicalName()), exception);
            }
        }
        return true;
    }
}

