/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.server;

import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.netty.NettyOptionSettingChannelInitializer;
import eu.cloudnetservice.driver.network.netty.codec.NettyPacketDecoder;
import eu.cloudnetservice.driver.network.netty.codec.NettyPacketEncoder;
import eu.cloudnetservice.driver.network.netty.codec.VarInt32FrameDecoder;
import eu.cloudnetservice.driver.network.netty.codec.VarInt32FramePrepender;
import eu.cloudnetservice.driver.network.netty.server.NettyNetworkServer;
import eu.cloudnetservice.driver.network.netty.server.NettyNetworkServerHandler;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import lombok.NonNull;

public class NettyNetworkServerInitializer
extends NettyOptionSettingChannelInitializer {
    private final HostAndPort serverLocalAddress;
    private final NettyNetworkServer networkServer;

    public NettyNetworkServerInitializer(@NonNull NettyNetworkServer networkServer, @NonNull HostAndPort serverLocalAddress) {
        if (networkServer == null) {
            throw new NullPointerException("networkServer is marked non-null but is null");
        }
        if (serverLocalAddress == null) {
            throw new NullPointerException("serverLocalAddress is marked non-null but is null");
        }
        this.networkServer = networkServer;
        this.serverLocalAddress = serverLocalAddress;
    }

    @Override
    protected void doInitChannel(@NonNull Channel ch) {
        if (ch == null) {
            throw new NullPointerException("ch is marked non-null but is null");
        }
        if (this.networkServer.sslContext != null) {
            ch.pipeline().addLast("ssl-handler", (ChannelHandler)this.networkServer.sslContext.newHandler(ch.bufferAllocator()));
        }
        ch.pipeline().addLast("packet-length-deserializer", (ChannelHandler)new VarInt32FrameDecoder()).addLast("packet-decoder", (ChannelHandler)new NettyPacketDecoder()).addLast("packet-length-serializer", (ChannelHandler)VarInt32FramePrepender.INSTANCE).addLast("packet-encoder", (ChannelHandler)NettyPacketEncoder.INSTANCE).addLast("network-server-handler", (ChannelHandler)new NettyNetworkServerHandler(this.networkServer, this.serverLocalAddress));
    }
}

