/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.server;

import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.netty.NettyNetworkChannel;
import eu.cloudnetservice.driver.network.netty.NettyNetworkHandler;
import eu.cloudnetservice.driver.network.netty.server.NettyNetworkServer;
import io.netty5.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.concurrent.Executor;
import lombok.NonNull;

public class NettyNetworkServerHandler
extends NettyNetworkHandler {
    private final HostAndPort serverLocalAddress;
    private final NettyNetworkServer networkServer;

    public NettyNetworkServerHandler(@NonNull NettyNetworkServer networkServer, @NonNull HostAndPort serverLocalAddress) {
        if (networkServer == null) {
            throw new NullPointerException("networkServer is marked non-null but is null");
        }
        if (serverLocalAddress == null) {
            throw new NullPointerException("serverLocalAddress is marked non-null but is null");
        }
        this.networkServer = networkServer;
        this.serverLocalAddress = serverLocalAddress;
    }

    @Override
    public void channelActive(@NonNull ChannelHandlerContext ctx) throws Exception {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.channel = new NettyNetworkChannel(ctx.channel(), this.networkServer.packetRegistry(), this.networkServer.handlerFactory.call(), this.serverLocalAddress, HostAndPort.fromSocketAddress(ctx.channel().remoteAddress()), false);
        this.networkServer.channels.add(this.channel);
        this.channel.handler().handleChannelInitialize(this.channel);
    }

    @Override
    @NonNull
    protected Collection<NetworkChannel> channels() {
        return this.networkServer.channels;
    }

    @Override
    @NonNull
    protected Executor packetDispatcher() {
        return this.networkServer.packetDispatcher();
    }
}

