/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.server;

import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.NetworkServer;
import eu.cloudnetservice.driver.network.netty.NettyOptionSettingChannelInitializer;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.server.NettyNetworkServerInitializer;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultPacketListenerRegistry;
import eu.cloudnetservice.driver.network.scheduler.NetworkTaskScheduler;
import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.handler.ssl.ClientAuth;
import io.netty5.handler.ssl.IdentityCipherSuiteFilter;
import io.netty5.handler.ssl.SslContext;
import io.netty5.handler.ssl.SslContextBuilder;
import io.netty5.handler.ssl.util.SelfSignedCertificate;
import io.netty5.util.concurrent.Future;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NettyNetworkServer
implements NetworkServer {
    protected static final WriteBufferWaterMark WATER_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    protected final SslContext sslContext;
    protected final EventLoopGroup bossEventLoopGroup;
    protected final EventLoopGroup workerEventLoopGroup;
    protected final Collection<NetworkChannel> channels = ConcurrentHashMap.newKeySet();
    protected final Map<HostAndPort, Future<Void>> channelFutures = new ConcurrentHashMap<HostAndPort, Future<Void>>();
    protected final PacketListenerRegistry packetRegistry = new DefaultPacketListenerRegistry();
    protected final NetworkTaskScheduler packetDispatcher;
    protected final Callable<NetworkChannelHandler> handlerFactory;

    public NettyNetworkServer(@NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory) {
        this(componentInfo, handlerFactory, null);
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
    }

    public NettyNetworkServer(@NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory, @Nullable SSLConfiguration sslConfiguration) {
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.handlerFactory = handlerFactory;
        this.sslContext = NettyNetworkServer.initializeSslContext(sslConfiguration);
        this.bossEventLoopGroup = NettyUtil.createBossEventLoopGroup();
        this.workerEventLoopGroup = NettyUtil.createWorkerEventLoopGroup(componentInfo.environment());
        this.packetDispatcher = NettyUtil.createPacketDispatcher(componentInfo.environment());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static SslContext initializeSslContext(@Nullable SSLConfiguration sslConfig) {
        if (sslConfig == null || !sslConfig.enabled()) {
            return null;
        }
        ClientAuth clientAuthMode = sslConfig.clientAuth() ? ClientAuth.REQUIRE : ClientAuth.NONE;
        try {
            Path keyPath = sslConfig.privateKeyPath();
            Path keyCertificatePath = sslConfig.certificatePath();
            if (keyPath != null && keyCertificatePath != null && Files.isRegularFile(keyPath, new LinkOption[0]) && Files.isRegularFile(keyCertificatePath, new LinkOption[0])) {
                try (InputStream keyStream = Files.newInputStream(keyPath, StandardOpenOption.READ);){
                    SslContext sslContext;
                    block18: {
                        InputStream keyCertChainStream = Files.newInputStream(keyCertificatePath, StandardOpenOption.READ);
                        try {
                            sslContext = SslContextBuilder.forServer(keyCertChainStream, keyStream, sslConfig.privateKeyPassword()).clientAuth(clientAuthMode).applicationProtocolConfig(null).sslProvider(NettyUtil.selectedSslProvider()).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).build();
                            if (keyCertChainStream == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (keyCertChainStream != null) {
                                try {
                                    keyCertChainStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        keyCertChainStream.close();
                    }
                    return sslContext;
                }
            }
            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
            return SslContextBuilder.forServer(selfSignedCertificate.certificate(), selfSignedCertificate.privateKey()).clientAuth(clientAuthMode).applicationProtocolConfig(null).sslProvider(NettyUtil.selectedSslProvider()).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).build();
        }
        catch (SSLException exception) {
            String errorMessage = String.format("Unable to build server ssl provider from configuration %s", sslConfig);
            throw new IllegalStateException(errorMessage, exception);
        }
        catch (CertificateException exception) {
            String errorMessage = String.format("Unable to generated self-signed certificate; ssl-config: %s", sslConfig);
            throw new IllegalStateException(errorMessage, exception);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Unable to open cert chain or private key for server ssl config %s", sslConfig);
            throw new IllegalStateException(errorMessage, exception);
        }
    }

    @Override
    public boolean sslEnabled() {
        return this.sslContext != null;
    }

    @Override
    @NonNull
    public CompletableFuture<Void> addListener(int port) {
        return this.addListener(new HostAndPort("0.0.0.0", port));
    }

    @Override
    @NonNull
    public CompletableFuture<Void> addListener(@NonNull HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((ServerBootstrap)new ServerBootstrap().channelFactory(NettyUtil.serverChannelFactory()).group(this.bossEventLoopGroup, this.workerEventLoopGroup).handler(new NettyOptionSettingChannelInitializer().option(ChannelOption.TCP_FASTOPEN, 3).option(ChannelOption.SO_REUSEADDR, true).option(UnixChannelOption.SO_REUSEPORT, true).option(ChannelOption.BUFFER_ALLOCATOR, NettyUtil.selectedBufferAllocator()))).childHandler(new NettyNetworkServerInitializer(this, hostAndPort).option(ChannelOption.IP_TOS, 24).option(ChannelOption.AUTO_READ, true).option(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_REUSEADDR, true).option(ChannelOption.SO_KEEPALIVE, true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, WATER_MARK).option(ChannelOption.BUFFER_ALLOCATOR, NettyUtil.selectedBufferAllocator())).bind(hostAndPort.host(), hostAndPort.port()).addListener((Future<? super V> future) -> {
            if (future.isSuccess()) {
                result.complete(null);
                this.channelFutures.put(hostAndPort, ((Channel)future.getNow()).closeFuture());
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    @Override
    public void close() {
        this.closeChannels();
        for (Future<Void> entry : this.channelFutures.values()) {
            entry.cancel();
        }
        this.packetDispatcher.shutdown();
        this.bossEventLoopGroup.shutdownGracefully();
        this.workerEventLoopGroup.shutdownGracefully();
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> channels() {
        return Collections.unmodifiableCollection(this.channels);
    }

    @Override
    @NonNull
    public Executor packetDispatcher() {
        return this.packetDispatcher;
    }

    @Override
    @NonNull
    public PacketListenerRegistry packetRegistry() {
        return this.packetRegistry;
    }

    @Override
    public void sendPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.channels) {
            channel.sendPacket(packet);
        }
    }

    @Override
    public void sendPacketSync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.channels) {
            channel.sendPacketSync(packet);
        }
    }

    @Override
    public void closeChannels() {
        Iterator<NetworkChannel> iterator = this.channels.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }
}

