/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.codec;

import eu.cloudnetservice.driver.network.netty.NettyUtil;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VarInt32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(@NonNull ChannelHandlerContext ctx, @NonNull Buffer in) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (!ctx.channel().isActive()) {
            return;
        }
        int readerIndex = in.readerOffset();
        Integer length = NettyUtil.readVarIntOrNull(in);
        if (length == null || readerIndex == in.readerOffset()) {
            in.readerOffset(readerIndex);
            return;
        }
        if (length <= 0) {
            if (in.readableBytes() > 0) {
                in.skipReadableBytes(in.readableBytes());
            }
            return;
        }
        if (in.readableBytes() >= length) {
            ctx.fireChannelRead(in.copy(in.readerOffset(), length));
            in.skipReadableBytes(length);
        } else {
            in.readerOffset(readerIndex);
        }
    }
}

