/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.codec;

import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.buffer.NettyImmutableDataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NettyPacketEncoder
extends MessageToByteEncoder<Packet> {
    public static final NettyPacketEncoder INSTANCE = new NettyPacketEncoder();

    @Override
    protected Buffer allocateBuffer(@NonNull ChannelHandlerContext ctx, @NonNull Packet msg) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        int bufferLength = 2 + msg.content().readableBytes() + NettyUtil.varIntBytes(msg.channel()) + NettyUtil.varIntBytes(msg.content().readableBytes());
        if (msg.uniqueId() != null) {
            bufferLength += 16;
        }
        return ctx.bufferAllocator().allocate(bufferLength);
    }

    @Override
    protected void encode(@NonNull ChannelHandlerContext ctx, @NonNull Packet msg, @NonNull Buffer out) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        NettyUtil.writeVarInt(out, msg.channel());
        out.writeBoolean(msg.prioritized());
        UUID queryUniqueId = msg.uniqueId();
        out.writeBoolean(queryUniqueId != null);
        if (queryUniqueId != null) {
            out.writeLong(queryUniqueId.getMostSignificantBits()).writeLong(queryUniqueId.getLeastSignificantBits());
        }
        Buffer content = ((NettyImmutableDataBuf)msg.content()).buffer();
        int length = content.readableBytes();
        NettyUtil.writeVarInt(out, length);
        content.copyInto(0, out, out.writerOffset(), length);
        out.skipWritableBytes(length);
        msg.content().release();
    }

    @Override
    public boolean isSharable() {
        return true;
    }
}

