/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.client;

import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClientInitializer;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import eu.cloudnetservice.driver.network.protocol.defaults.DefaultPacketListenerRegistry;
import eu.cloudnetservice.driver.network.scheduler.NetworkTaskScheduler;
import eu.cloudnetservice.driver.network.ssl.SSLConfiguration;
import io.netty5.bootstrap.Bootstrap;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.handler.ssl.IdentityCipherSuiteFilter;
import io.netty5.handler.ssl.SslContext;
import io.netty5.handler.ssl.SslContextBuilder;
import io.netty5.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NettyNetworkClient
implements NetworkClient {
    private static final int CONNECTION_TIMEOUT_MILLIS = 5000;
    private static final WriteBufferWaterMark WATER_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    protected final SslContext sslContext;
    protected final EventLoopGroup eventLoopGroup;
    protected final Collection<NetworkChannel> channels = ConcurrentHashMap.newKeySet();
    protected final PacketListenerRegistry packetRegistry = new DefaultPacketListenerRegistry();
    protected final NetworkTaskScheduler packetDispatcher;
    protected final Callable<NetworkChannelHandler> handlerFactory;

    public NettyNetworkClient(@NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory) {
        this(componentInfo, handlerFactory, null);
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
    }

    public NettyNetworkClient(@NonNull ComponentInfo componentInfo, @NonNull Callable<NetworkChannelHandler> handlerFactory, @Nullable SSLConfiguration sslConfiguration) {
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.handlerFactory = handlerFactory;
        this.sslContext = NettyNetworkClient.initializeSslContext(sslConfiguration);
        this.packetDispatcher = NettyUtil.createPacketDispatcher(componentInfo.environment());
        this.eventLoopGroup = NettyUtil.createWorkerEventLoopGroup(componentInfo.environment());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static SslContext initializeSslContext(@Nullable SSLConfiguration sslConfig) {
        SslContext sslContext;
        if (sslConfig == null || !sslConfig.enabled()) {
            return null;
        }
        Path trustCertificatePath = sslConfig.trustCertificatePath();
        if (trustCertificatePath == null || !Files.isRegularFile(trustCertificatePath, new LinkOption[0])) return SslContextBuilder.forClient().applicationProtocolConfig(null).sslProvider(NettyUtil.selectedSslProvider()).trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).build();
        InputStream trustCertCollectionStream = Files.newInputStream(trustCertificatePath, StandardOpenOption.READ);
        try {
            sslContext = SslContextBuilder.forClient().applicationProtocolConfig(null).trustManager(trustCertCollectionStream).sslProvider(NettyUtil.selectedSslProvider()).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).build();
            if (trustCertCollectionStream == null) return sslContext;
        }
        catch (Throwable throwable) {
            String errorMessage;
            try {
                if (trustCertCollectionStream == null) throw throwable;
                try {
                    trustCertCollectionStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SSLException exception) {
                errorMessage = String.format("Unable to build client ssl provider from configuration %s", sslConfig);
                throw new IllegalStateException(errorMessage, exception);
            }
            catch (IOException exception) {
                errorMessage = String.format("Unable to open trust certificate at %s for reading", sslConfig.trustCertificatePath());
                throw new IllegalStateException(errorMessage, exception);
            }
        }
        trustCertCollectionStream.close();
        return sslContext;
    }

    @Override
    public boolean sslEnabled() {
        return this.sslContext != null;
    }

    @Override
    @NonNull
    public CompletableFuture<Void> connect(@NonNull HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            throw new NullPointerException("hostAndPort is marked non-null but is null");
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channelFactory(NettyUtil.clientChannelFactory()).handler(new NettyNetworkClientInitializer(hostAndPort, this).option(ChannelOption.IP_TOS, 24).option(ChannelOption.AUTO_READ, true).option(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_REUSEADDR, true).option(ChannelOption.TCP_FASTOPEN_CONNECT, true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, WATER_MARK).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000).option(ChannelOption.BUFFER_ALLOCATOR, NettyUtil.selectedBufferAllocator()))).connect(hostAndPort.host(), hostAndPort.port()).addListener(future -> {
            if (future.isSuccess()) {
                result.complete(null);
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    @Override
    public void close() {
        this.closeChannels();
        this.packetDispatcher.shutdown();
        this.eventLoopGroup.shutdownGracefully();
    }

    @Override
    @NonNull
    public Collection<NetworkChannel> channels() {
        return Collections.unmodifiableCollection(this.channels);
    }

    @Override
    @NonNull
    public Executor packetDispatcher() {
        return this.packetDispatcher;
    }

    @Override
    @NonNull
    public PacketListenerRegistry packetRegistry() {
        return this.packetRegistry;
    }

    @Override
    public void sendPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.channels) {
            channel.sendPacket(packet);
        }
    }

    @Override
    public void sendPacketSync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (NetworkChannel channel : this.channels) {
            channel.sendPacketSync(packet);
        }
    }

    @Override
    public void closeChannels() {
        Iterator<NetworkChannel> iterator = this.channels.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }
}

