/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.buffer;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.AllocatorControl;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.Drop;
import io.netty5.buffer.StandardAllocationTypes;
import io.netty5.buffer.bytebuffer.ByteBufferMemoryManager;
import io.netty5.buffer.internal.ArcDrop;
import io.netty5.buffer.internal.CleanerDrop;
import io.netty5.buffer.internal.InternalBufferUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class NettyNioBufferReleasingAllocator
implements BufferAllocator,
AllocatorControl {
    private final ByteBufferMemoryManager manager = new ByteBufferMemoryManager();
    private volatile boolean closed;

    public static boolean notAbleToFreeBuffers() {
        return DirectBufferFreeDrop.DIRECT_BUFFER_CLEANER == null;
    }

    @Override
    @NonNull
    public AllocationType getAllocationType() {
        return StandardAllocationTypes.OFF_HEAP;
    }

    @Override
    @NonNull
    public Buffer allocate(int size) {
        if (this.closed) {
            throw InternalBufferUtils.allocatorClosedException();
        }
        InternalBufferUtils.assertValidBufferSize(size);
        return this.manager.allocateShared(this, size, drop -> {
            DirectBufferFreeDrop freeingDrop = new DirectBufferFreeDrop(this.manager);
            return CleanerDrop.wrap(ArcDrop.wrap(freeingDrop), this.manager);
        }, StandardAllocationTypes.OFF_HEAP);
    }

    @Override
    @NonNull
    public Supplier<Buffer> constBufferSupplier(byte[] bytes) {
        if (this.closed) {
            throw InternalBufferUtils.allocatorClosedException();
        }
        Buffer constantBuffer = this.manager.allocateShared(this, bytes.length, drop -> {
            DirectBufferFreeDrop freeingDrop = new DirectBufferFreeDrop(this.manager);
            return CleanerDrop.wrapWithoutLeakDetection(ArcDrop.wrap(freeingDrop), this.manager);
        }, StandardAllocationTypes.OFF_HEAP);
        constantBuffer.writeBytes(bytes).makeReadOnly();
        return () -> this.manager.allocateConstChild(constantBuffer);
    }

    @Override
    @NonNull
    public BufferAllocator getAllocator() {
        return this;
    }

    @Override
    public boolean isPooling() {
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private record DirectBufferFreeDrop(@NonNull ByteBufferMemoryManager memoryManager) implements Drop<Buffer>
    {
        private static final MethodHandle DIRECT_BUFFER_CLEANER;
        private static final Logger LOGGER;

        @Generated
        public DirectBufferFreeDrop(@NonNull ByteBufferMemoryManager memoryManager) {
            if (memoryManager == null) {
                throw new NullPointerException("memoryManager is marked non-null but is null");
            }
        }

        @Override
        public void drop(@NonNull Buffer obj) {
            if (obj == null) {
                throw new NullPointerException("obj is marked non-null but is null");
            }
            ByteBuffer recoverableMemory = (ByteBuffer)this.memoryManager.unwrapRecoverableMemory(obj);
            if (DIRECT_BUFFER_CLEANER != null && recoverableMemory.isDirect()) {
                try {
                    DIRECT_BUFFER_CLEANER.invokeExact(recoverableMemory);
                }
                catch (Throwable exception) {
                    LOGGER.debug("Unable to free direct ByteBuf using Unsafe.invokeCleaner: {}", (Object)exception.getMessage());
                }
            }
        }

        @Override
        @NonNull
        public Drop<Buffer> fork() {
            throw new IllegalStateException("Cannot fork DirectBufferFreeDrop, must be guarded by an ArcDrop");
        }

        @Override
        public void attach(@NonNull Buffer obj) {
            if (obj == null) {
                throw new NullPointerException("obj is marked non-null but is null");
            }
        }

        static {
            MethodHandle directBufferCleaner;
            LOGGER = LoggerFactory.getLogger(DirectBufferFreeDrop.class);
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType icMethodType = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                directBufferCleaner = lookup.findVirtual(unsafeClass, "invokeCleaner", icMethodType).bindTo(theUnsafe);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
                LOGGER.warn("Unable to get access to Unsafe.invokeCleaner which could result in higher memory consumption: {}", (Object)ex.getMessage());
                directBufferCleaner = null;
            }
            DIRECT_BUFFER_CLEANER = directBufferCleaner;
        }
    }
}

