/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import eu.cloudnetservice.driver.DriverEnvironment;
import eu.cloudnetservice.driver.network.netty.NettyTransport;
import eu.cloudnetservice.driver.network.netty.buffer.NettyNioBufferReleasingAllocator;
import eu.cloudnetservice.driver.network.scheduler.NetworkTaskScheduler;
import eu.cloudnetservice.driver.network.scheduler.ScalingNetworkTaskScheduler;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelFactory;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.ssl.OpenSsl;
import io.netty5.handler.ssl.SslProvider;
import io.netty5.util.ResourceLeakDetector;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class NettyUtil {
    private static final int PACKET_DISPATCH_THREADS;
    private static final int NETTY_EVENT_LOOP_THREADS;
    private static final SslProvider SELECTED_SSL_PROVIDER;
    private static final NettyTransport SELECTED_NETTY_TRANSPORT;
    private static final BufferAllocator SELECTED_BUFFER_ALLOCATOR;

    private NettyUtil() {
        throw new UnsupportedOperationException();
    }

    private static int overriddenCountOrDefault(int overriddenSetting, int defaultValue) {
        return overriddenSetting >= 1 ? overriddenSetting : defaultValue;
    }

    @NonNull
    public static NetworkTaskScheduler createPacketDispatcher(@NonNull DriverEnvironment driverEnvironment) {
        if (driverEnvironment == null) {
            throw new NullPointerException("driverEnvironment is marked non-null but is null");
        }
        int defaultEnvThreadCount = driverEnvironment.equals(DriverEnvironment.NODE) ? 12 : 4;
        int maximumPoolSize = NettyUtil.overriddenCountOrDefault(PACKET_DISPATCH_THREADS, defaultEnvThreadCount);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Packet-Dispatcher-%d").setThreadFactory(Executors.defaultThreadFactory()).build();
        return new ScalingNetworkTaskScheduler(threadFactory, maximumPoolSize);
    }

    @NonNull
    public static EventLoopGroup createBossEventLoopGroup() {
        return SELECTED_NETTY_TRANSPORT.createEventLoopGroup(1);
    }

    @NonNull
    public static EventLoopGroup createWorkerEventLoopGroup(@NonNull DriverEnvironment driverEnvironment) {
        if (driverEnvironment == null) {
            throw new NullPointerException("driverEnvironment is marked non-null but is null");
        }
        int defaultEnvThreadCount = driverEnvironment.equals(DriverEnvironment.NODE) ? 6 : 2;
        int threadCount = NettyUtil.overriddenCountOrDefault(NETTY_EVENT_LOOP_THREADS, defaultEnvThreadCount);
        return SELECTED_NETTY_TRANSPORT.createEventLoopGroup(threadCount);
    }

    @NonNull
    public static ChannelFactory<? extends Channel> clientChannelFactory() {
        return SELECTED_NETTY_TRANSPORT.clientChannelFactory();
    }

    @NonNull
    public static ServerChannelFactory<? extends ServerChannel> serverChannelFactory() {
        return SELECTED_NETTY_TRANSPORT.serverChannelFactory();
    }

    @NonNull
    public static Buffer writeVarInt(@NonNull Buffer buffer, int value) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.writeByte((byte)value);
                return buffer;
            }
            buffer.writeByte((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static int readVarInt(@NonNull Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        Integer varInt = NettyUtil.readVarIntOrNull(buffer);
        if (varInt == null) {
            String bufferDump = BufferUtil.hexDump(buffer, 0, buffer.readableBytes());
            throw new DecoderException(String.format("Unable to decode VarInt at current buffer position (%d): %s", buffer.readerOffset(), bufferDump));
        }
        return varInt;
    }

    @Nullable
    public static Integer readVarIntOrNull(@NonNull Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int i = 0;
        int maxRead = Math.min(5, buffer.readableBytes());
        for (int j = 0; j < maxRead; ++j) {
            byte nextByte = buffer.readByte();
            i |= (nextByte & 0x7F) << j * 7;
            if ((nextByte & 0x80) == 128) continue;
            return i;
        }
        return null;
    }

    public static int varIntBytes(int value) {
        if (value < 0 || value >= 0x10000000) {
            return 5;
        }
        if (value < 128) {
            return 1;
        }
        if (value < 16384) {
            return 2;
        }
        if (value < 0x200000) {
            return 3;
        }
        return 4;
    }

    @NonNull
    public static NettyTransport selectedNettyTransport() {
        return SELECTED_NETTY_TRANSPORT;
    }

    @NonNull
    public static SslProvider selectedSslProvider() {
        return SELECTED_SSL_PROVIDER;
    }

    @NonNull
    public static BufferAllocator selectedBufferAllocator() {
        return SELECTED_BUFFER_ALLOCATOR;
    }

    static {
        boolean enableLeakDetection = Boolean.getBoolean("cloudnet.net.leak-detection-enabled");
        if (enableLeakDetection) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.PARANOID);
            System.setProperty("io.netty5.buffer.leakDetectionEnabled", "true");
        } else {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
            System.setProperty("io.netty5.buffer.leakDetectionEnabled", "false");
        }
        String preferredSslProvider = System.getProperty("cloudnet.net.preferred-ssl-provider");
        SELECTED_SSL_PROVIDER = "jdk".equals(preferredSslProvider) || !OpenSsl.isAvailable() ? SslProvider.JDK : SslProvider.OPENSSL;
        String preferredBufferAllocator = System.getProperty("cloudnet.net.preferred-buffer-allocator");
        SELECTED_BUFFER_ALLOCATOR = "netty-default".equals(preferredBufferAllocator) || NettyNioBufferReleasingAllocator.notAbleToFreeBuffers() ? DefaultBufferAllocators.offHeapAllocator() : new NettyNioBufferReleasingAllocator();
        boolean disableNativeTransport = Boolean.getBoolean("cloudnet.net.no-native");
        SELECTED_NETTY_TRANSPORT = NettyTransport.availableTransport(disableNativeTransport);
        PACKET_DISPATCH_THREADS = Integer.getInteger("cloudnet.net.packet-dispatch-threads", -1);
        NETTY_EVENT_LOOP_THREADS = Integer.getInteger("cloudnet.net.netty-event-loop-threads", -1);
    }
}

