/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NettyOptionSettingChannelInitializer
extends ChannelInitializer<Channel> {
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();

    @Override
    protected void initChannel(@NonNull Channel channel) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        for (Map.Entry<ChannelOption<?>, Object> optionEntry : this.options.entrySet()) {
            ChannelOption<?> option = optionEntry.getKey();
            if (!channel.isOptionSupported(option)) continue;
            channel.setOption(option, optionEntry.getValue());
        }
        this.doInitChannel(channel);
    }

    @NonNull
    public <T> NettyOptionSettingChannelInitializer option(@NonNull ChannelOption<T> option, @NonNull T value) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.options.put(option, value);
        return this;
    }

    protected void doInitChannel(@NonNull Channel channel) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
    }
}

