/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import eu.cloudnetservice.driver.network.DefaultNetworkChannel;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListenerRegistry;
import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseCombiner;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NettyNetworkChannel
extends DefaultNetworkChannel
implements NetworkChannel {
    private final Channel channel;

    public NettyNetworkChannel(@NonNull Channel channel, @NonNull PacketListenerRegistry packetRegistry, @NonNull NetworkChannelHandler handler, @NonNull HostAndPort serverAddress, @NonNull HostAndPort clientAddress, boolean clientProvidedChannel) {
        super(packetRegistry, serverAddress, clientAddress, clientProvidedChannel, handler);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packetRegistry == null) {
            throw new NullPointerException("packetRegistry is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (serverAddress == null) {
            throw new NullPointerException("serverAddress is marked non-null but is null");
        }
        if (clientAddress == null) {
            throw new NullPointerException("clientAddress is marked non-null but is null");
        }
        this.channel = channel;
    }

    @Override
    public void sendPacket(Packet ... packets) {
        if (packets == null) {
            throw new NullPointerException("packets is marked non-null but is null");
        }
        EventLoop executor = this.channel.executor();
        if (executor.inEventLoop()) {
            PromiseCombiner combiner = new PromiseCombiner(executor);
            for (Packet packet : packets) {
                Future<Void> writeFuture = this.channel.write(packet);
                combiner.add(writeFuture);
            }
            Promise<Void> promise = this.channel.newPromise();
            combiner.finish(promise);
            promise.asFuture().addListener(future -> this.channel.flush());
        } else {
            executor.execute(() -> this.sendPacket(packets));
        }
    }

    @Override
    public void sendPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        this.channel.writeAndFlush(packet);
    }

    @Override
    public void sendPacketSync(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        Future<Void> future = this.channel.writeAndFlush(packet);
        if (!future.executor().inEventLoop()) {
            try {
                future.asStage().await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean writeable() {
        return this.channel.isWritable();
    }

    @Override
    public boolean active() {
        return this.channel.isActive();
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

