/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults.factory;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.chunk.ChunkedPacketSessionOpenEvent;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import java.util.function.Function;
import lombok.NonNull;

public final class EventChunkHandlerFactory
implements Function<ChunkSessionInformation, ChunkedPacketHandler> {
    private final EventManager eventManager;

    public EventChunkHandlerFactory(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }

    @Override
    @NonNull
    public ChunkedPacketHandler apply(@NonNull ChunkSessionInformation info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        ChunkedPacketHandler handler = this.eventManager.callEvent(new ChunkedPacketSessionOpenEvent(info)).handler();
        if (handler == null) {
            throw new IllegalStateException("No chunked handler for " + String.valueOf(info));
        }
        return handler;
    }
}

