/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults.builder;

import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultFileChunkPacketSender;
import eu.cloudnetservice.driver.network.chunk.defaults.builder.DefaultChunkedPacketSenderBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.NonNull;

public class FileChunkedPacketSenderBuilder
extends DefaultChunkedPacketSenderBuilder {
    @NonNull
    public FileChunkedPacketSenderBuilder forFile(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            this.source(Files.newInputStream(path, new OpenOption[0]));
            return this;
        }
        catch (IOException exception) {
            throw new AssertionError("Unexpected exception opening file stream", exception);
        }
    }

    @Override
    @NonNull
    protected ChunkedPacketSender doBuild() {
        return new DefaultFileChunkPacketSender(new ChunkSessionInformation(this.chunkSize, this.sessionUniqueId, this.transferChannel, this.transferInformation), this.source, this.packetSplitter);
    }
}

