/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.TransferStatus;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultChunkedPacketProvider;
import eu.cloudnetservice.driver.network.chunk.network.ChunkedPacket;
import eu.cloudnetservice.driver.network.protocol.Packet;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.NonNull;

public class DefaultFileChunkPacketSender
extends DefaultChunkedPacketProvider
implements ChunkedPacketSender {
    protected final InputStream source;
    protected final Consumer<Packet> packetSplitter;

    public DefaultFileChunkPacketSender(@NonNull ChunkSessionInformation sessionInformation, @NonNull InputStream source, @NonNull Consumer<Packet> packetSplitter) {
        super(sessionInformation);
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (packetSplitter == null) {
            throw new NullPointerException("packetSplitter is marked non-null but is null");
        }
        this.source = source;
        this.packetSplitter = packetSplitter;
    }

    @Override
    @NonNull
    public CompletableFuture<TransferStatus> transferChunkedData() {
        return TaskUtil.supplyAsync(() -> {
            ChunkedPacket chunkPacket;
            int bytesRead;
            int chunkIndex = 0;
            byte[] backingArray = new byte[this.chunkSessionInformation.chunkSize()];
            while ((bytesRead = Math.max(0, this.source.read(backingArray))) == backingArray.length) {
                this.chunkSessionInformation.transferInformation().acquire();
                chunkPacket = ChunkedPacket.createFullChunk(chunkIndex++, backingArray, this.chunkSessionInformation);
                this.packetSplitter.accept(chunkPacket);
            }
            chunkPacket = ChunkedPacket.createFinalChunk(chunkIndex, bytesRead, backingArray, this.chunkSessionInformation);
            this.packetSplitter.accept(chunkPacket);
            this.source.close();
            this.chunkSessionInformation.transferInformation().release();
            return TransferStatus.SUCCESS;
        });
    }
}

