/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults;

import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.NonNull;

@Singleton
public final class ChunkedSessionRegistry {
    private final Map<UUID, ChunkedPacketHandler> runningSessions = new ConcurrentHashMap<UUID, ChunkedPacketHandler>();

    public void completeSession(@NonNull UUID sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        this.runningSessions.remove(sessionId);
    }

    public void registerSession(@NonNull UUID sessionId, @NonNull ChunkedPacketHandler handler) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.runningSessions.putIfAbsent(sessionId, handler);
    }

    @NonNull
    public ChunkedPacketHandler getOrCreateSession(@NonNull ChunkSessionInformation sessionInformation, @NonNull Function<ChunkSessionInformation, ChunkedPacketHandler> sessionFactory) {
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
        if (sessionFactory == null) {
            throw new NullPointerException("sessionFactory is marked non-null but is null");
        }
        return this.runningSessions.computeIfAbsent(sessionInformation.sessionUniqueId(), uUID -> (ChunkedPacketHandler)sessionFactory.apply(sessionInformation));
    }
}

