/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.data;

import com.google.common.base.Utf8;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufable;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ChunkSessionInformation
implements DataBufable {
    private int chunkSize;
    private UUID sessionUniqueId;
    private String transferChannel;
    private DataBuf transferInformation;

    @ApiStatus.Internal
    public ChunkSessionInformation() {
    }

    public ChunkSessionInformation(int chunkSize, @NonNull UUID sessionUniqueId, @NonNull String transferChannel, @NonNull DataBuf transferInformation) {
        if (sessionUniqueId == null) {
            throw new NullPointerException("sessionUniqueId is marked non-null but is null");
        }
        if (transferChannel == null) {
            throw new NullPointerException("transferChannel is marked non-null but is null");
        }
        if (transferInformation == null) {
            throw new NullPointerException("transferInformation is marked non-null but is null");
        }
        this.chunkSize = chunkSize;
        this.sessionUniqueId = sessionUniqueId;
        this.transferChannel = transferChannel;
        this.transferInformation = transferInformation;
    }

    @ApiStatus.Internal
    public int packetSizeBytes() {
        int channelBytes = Utf8.encodedLength(this.transferChannel);
        int channelBytesLengthSize = NettyUtil.varIntBytes(channelBytes);
        int transferBytes = this.transferInformation.readableBytes();
        int transferInfoLengthSize = NettyUtil.varIntBytes(transferBytes);
        return 21 + channelBytesLengthSize + channelBytes + transferInfoLengthSize + transferBytes;
    }

    @Override
    public void writeData(@NonNull DataBuf.Mutable dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        dataBuf.writeInt(this.chunkSize);
        dataBuf.writeUniqueId(this.sessionUniqueId);
        dataBuf.writeString(this.transferChannel);
        dataBuf.writeDataBuf(this.transferInformation.acquire());
    }

    @Override
    public void readData(@NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        this.chunkSize = dataBuf.readInt();
        this.sessionUniqueId = dataBuf.readUniqueId();
        this.transferChannel = dataBuf.readString();
        this.transferInformation = dataBuf.readDataBuf();
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    @NonNull
    public UUID sessionUniqueId() {
        return this.sessionUniqueId;
    }

    @NonNull
    public String transferChannel() {
        return this.transferChannel;
    }

    @NonNull
    public DataBuf transferInformation() {
        return this.transferInformation;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkSessionInformation)) {
            return false;
        }
        ChunkSessionInformation that = (ChunkSessionInformation)o;
        return this.sessionUniqueId.equals(that.sessionUniqueId());
    }

    public int hashCode() {
        return this.sessionUniqueId.hashCode();
    }

    @NonNull
    public String toString() {
        return "ChunkSessionInformation[chunkSize=" + this.chunkSize + ", sessionUniqueId=" + String.valueOf(this.sessionUniqueId) + ", transferChannel=" + this.transferChannel + ", transferInformation=" + String.valueOf(this.transferInformation) + "]";
    }
}

