/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module.util;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleDependencyNotFoundException;
import eu.cloudnetservice.driver.module.ModuleDependencyOutdatedException;
import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModuleDependencyUtil {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*))?)?");

    private ModuleDependencyUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Set<ModuleWrapper> collectDependencies(@NonNull ModuleWrapper caller, @NonNull ModuleProvider moduleProvider) {
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (moduleProvider == null) {
            throw new NullPointerException("moduleProvider is marked non-null but is null");
        }
        ArrayDeque<ModuleWrapper> visitedNodes = new ArrayDeque<ModuleWrapper>();
        HashSet<ModuleWrapper> rootDependencyNodes = new HashSet<ModuleWrapper>();
        visitedNodes.add(caller);
        for (ModuleDependency dependingModule : caller.dependingModules()) {
            ModuleWrapper wrapper = ModuleDependencyUtil.associatedModuleWrapper(dependingModule, moduleProvider, caller);
            rootDependencyNodes.add(wrapper);
            visitedNodes.add(wrapper);
            ModuleDependencyUtil.visitDependencies(visitedNodes, wrapper.dependingModules(), caller, wrapper, moduleProvider);
        }
        return rootDependencyNodes;
    }

    private static void visitDependencies(@NonNull Deque<ModuleWrapper> visitedNodes, @NonNull Collection<ModuleDependency> dependencies, @NonNull ModuleWrapper originalSource, @NonNull ModuleWrapper dependencyHolder, @NonNull ModuleProvider moduleProvider) {
        if (visitedNodes == null) {
            throw new NullPointerException("visitedNodes is marked non-null but is null");
        }
        if (dependencies == null) {
            throw new NullPointerException("dependencies is marked non-null but is null");
        }
        if (originalSource == null) {
            throw new NullPointerException("originalSource is marked non-null but is null");
        }
        if (dependencyHolder == null) {
            throw new NullPointerException("dependencyHolder is marked non-null but is null");
        }
        if (moduleProvider == null) {
            throw new NullPointerException("moduleProvider is marked non-null but is null");
        }
        for (ModuleDependency dependency : dependencies) {
            ModuleWrapper wrapper = ModuleDependencyUtil.associatedModuleWrapper(dependency, moduleProvider, dependencyHolder);
            Preconditions.checkArgument(!wrapper.module().name().equals(originalSource.module().name()), "Circular dependency detected: %s depends on caller module %s defined by %s", (Object)wrapper.module().name(), (Object)originalSource.module().name(), (Object)dependencyHolder.module().name());
            if (!visitedNodes.add(wrapper)) continue;
            ModuleDependencyUtil.visitDependencies(visitedNodes, wrapper.dependingModules(), originalSource, wrapper, moduleProvider);
        }
    }

    @NonNull
    private static ModuleWrapper associatedModuleWrapper(@NonNull ModuleDependency dependency, @NonNull ModuleProvider provider, @NonNull ModuleWrapper dependencyHolder) {
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (dependencyHolder == null) {
            throw new NullPointerException("dependencyHolder is marked non-null but is null");
        }
        ModuleWrapper wrapper = provider.module(dependency.name());
        if (wrapper == null) {
            throw new ModuleDependencyNotFoundException(dependency.name(), dependencyHolder.module().name());
        }
        Matcher dependencyVersion = SEMVER_PATTERN.matcher(dependency.version());
        Matcher moduleVersion = SEMVER_PATTERN.matcher(wrapper.module().version());
        if (dependencyVersion.matches() && moduleVersion.matches()) {
            ModuleDependencyUtil.checkDependencyVersion(dependencyHolder, dependency, dependencyVersion, moduleVersion);
        }
        return wrapper;
    }

    private static void checkDependencyVersion(@NonNull ModuleWrapper requiringModule, @NonNull ModuleDependency dependency, @NonNull Matcher dependencyVersion, @NonNull Matcher moduleVersion) {
        if (requiringModule == null) {
            throw new NullPointerException("requiringModule is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        if (dependencyVersion == null) {
            throw new NullPointerException("dependencyVersion is marked non-null but is null");
        }
        if (moduleVersion == null) {
            throw new NullPointerException("moduleVersion is marked non-null but is null");
        }
        int moduleMajor = Integer.parseInt(moduleVersion.group(1));
        int dependencyMajor = Integer.parseInt(dependencyVersion.group(1));
        if (dependencyMajor != moduleMajor) {
            throw new ModuleDependencyOutdatedException(requiringModule, dependency, "major", dependencyMajor, moduleMajor);
        }
        if (dependencyVersion.groupCount() > 1) {
            int moduleMinor;
            int dependencyMinor = Integer.parseInt(dependencyVersion.group(2));
            int n = moduleMinor = moduleVersion.groupCount() == 1 ? 0 : Integer.parseInt(moduleVersion.group(2));
            if (dependencyMinor > moduleMinor) {
                throw new ModuleDependencyOutdatedException(requiringModule, dependency, "minor", dependencyMinor, moduleMinor);
            }
        }
    }
}

