/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module.driver;

import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.util.Qualifiers;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.module.DefaultModule;
import eu.cloudnetservice.driver.module.driver.ModuleConfigurationInvalidException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;

public class DriverModule
extends DefaultModule {
    protected static final Element CONFIG_PATH_ELEMENT = Element.forType(Path.class).requireAnnotation(Qualifiers.named("configPath"));

    @NonNull
    public Document readConfig(@NonNull DocumentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return factory.parse(this.configPath());
    }

    public void writeConfig(@NonNull Document config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        config.writeTo(this.configPath());
    }

    @NonNull
    public <T> T readConfig(@NonNull Class<T> configModelType, @NonNull Supplier<T> defaultConfigFactory, @NonNull DocumentFactory documentFactory) {
        if (configModelType == null) {
            throw new NullPointerException("configModelType is marked non-null but is null");
        }
        if (defaultConfigFactory == null) {
            throw new NullPointerException("defaultConfigFactory is marked non-null but is null");
        }
        if (documentFactory == null) {
            throw new NullPointerException("documentFactory is marked non-null but is null");
        }
        if (Files.notExists(this.configPath(), new LinkOption[0])) {
            T config = defaultConfigFactory.get();
            this.writeConfig(documentFactory.newDocument().appendTree(config));
            return config;
        }
        try {
            return documentFactory.parse(this.configPath()).toInstanceOf(configModelType);
        }
        catch (Exception exception) {
            throw new ModuleConfigurationInvalidException(this.configPath(), exception);
        }
    }

    @NonNull
    public <C, T> T readConfigAndInstantiate(@NonNull InjectionLayer<?> injectionLayer, @NonNull Class<C> configModelType, @NonNull Supplier<C> defaultConfigFactory, @NonNull Class<T> classToInstantiate, @NonNull DocumentFactory documentFactory) {
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        if (configModelType == null) {
            throw new NullPointerException("configModelType is marked non-null but is null");
        }
        if (defaultConfigFactory == null) {
            throw new NullPointerException("defaultConfigFactory is marked non-null but is null");
        }
        if (classToInstantiate == null) {
            throw new NullPointerException("classToInstantiate is marked non-null but is null");
        }
        if (documentFactory == null) {
            throw new NullPointerException("documentFactory is marked non-null but is null");
        }
        return this.readConfigAndInstantiate(injectionLayer, configModelType, defaultConfigFactory, classToInstantiate, $2 -> {}, documentFactory);
    }

    @NonNull
    public <C, T> T readConfigAndInstantiate(@NonNull InjectionLayer<?> injectionLayer, @NonNull Class<C> configModelType, @NonNull Supplier<C> defaultConfigFactory, @NonNull Class<T> classToInstantiate, @NonNull Consumer<InjectionContext.Builder> builderDecorator, @NonNull DocumentFactory documentFactory) {
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        if (configModelType == null) {
            throw new NullPointerException("configModelType is marked non-null but is null");
        }
        if (defaultConfigFactory == null) {
            throw new NullPointerException("defaultConfigFactory is marked non-null but is null");
        }
        if (classToInstantiate == null) {
            throw new NullPointerException("classToInstantiate is marked non-null but is null");
        }
        if (builderDecorator == null) {
            throw new NullPointerException("builderDecorator is marked non-null but is null");
        }
        if (documentFactory == null) {
            throw new NullPointerException("documentFactory is marked non-null but is null");
        }
        Object config = this.readConfig(configModelType, defaultConfigFactory, documentFactory);
        return injectionLayer.instance(classToInstantiate, builder -> {
            builder.override(configModelType, config);
            builder.override(CONFIG_PATH_ELEMENT, this.configPath());
            builderDecorator.accept((InjectionContext.Builder)builder);
        });
    }

    @NonNull
    public Path configPath() {
        return this.moduleWrapper().dataDirectory().resolve("config.json");
    }
}

