/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import com.google.common.collect.ObjectArrays;
import dev.derklaro.aerogel.SpecifiedInjector;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.inject.InjectionLayerHolder;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModuleURLClassLoader
extends URLClassLoader
implements InjectionLayerHolder<SpecifiedInjector> {
    protected static final Lock CLASS_LOADING_LOCK = new ReentrantLock();
    protected static final Set<ModuleURLClassLoader> LOADERS = new HashSet<ModuleURLClassLoader>();
    protected final InjectionLayer<SpecifiedInjector> injectionLayer;

    public ModuleURLClassLoader(@NonNull URL moduleFileUrl, @NonNull Set<URL> moduleDependencyUrls, @NonNull InjectionLayer<SpecifiedInjector> injectionLayer) {
        super(ObjectArrays.concat(moduleFileUrl, moduleDependencyUrls.toArray(new URL[0])), ModuleURLClassLoader.class.getClassLoader());
        if (moduleFileUrl == null) {
            throw new NullPointerException("moduleFileUrl is marked non-null but is null");
        }
        if (moduleDependencyUrls == null) {
            throw new NullPointerException("moduleDependencyUrls is marked non-null but is null");
        }
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        this.injectionLayer = injectionLayer;
    }

    public void registerGlobally() {
        try {
            CLASS_LOADING_LOCK.lock();
            LOADERS.add(this);
        }
        finally {
            CLASS_LOADING_LOCK.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            CLASS_LOADING_LOCK.lock();
            LOADERS.remove(this);
            this.injectionLayer.close();
            super.close();
        }
        finally {
            CLASS_LOADING_LOCK.unlock();
        }
    }

    @Override
    @NonNull
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true);
    }

    @Override
    @NonNull
    public InjectionLayer<SpecifiedInjector> injectionLayer() {
        return this.injectionLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    protected Class<?> loadClass(String name, boolean resolve, boolean global) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!global) throw new ClassNotFoundException(name);
            CLASS_LOADING_LOCK.lock();
            try {
                for (ModuleURLClassLoader loader : LOADERS) {
                    if (loader == this) continue;
                    try {
                        Class<?> clazz = loader.loadClass(name, resolve, false);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            throw new ClassNotFoundException(name);
                        }
                    }
                }
            }
            finally {
                CLASS_LOADING_LOCK.unlock();
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

