/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import dev.derklaro.aerogel.Element;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.Result;
import eu.cloudnetservice.driver.inject.InjectUtil;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.module.Module;
import eu.cloudnetservice.driver.module.ModuleTask;
import eu.cloudnetservice.driver.module.ModuleTaskEntry;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import java.lang.reflect.Method;
import lombok.NonNull;

public class DefaultModuleTaskEntry
implements ModuleTaskEntry {
    protected static final String METHOD_SIGNATURE_FORMAT = "%s@%s()";
    protected final MethodAccessor<?> methodAccessor;
    protected final Element[] paramTypes;
    protected final InjectionLayer<?> injectionLayer;
    protected final ModuleTask moduleTask;
    protected final ModuleWrapper moduleWrapper;
    protected final String fullMethodSignatureCached;

    public DefaultModuleTaskEntry(@NonNull ModuleWrapper wrapper, @NonNull ModuleTask task, @NonNull Method method) throws IllegalAccessException {
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.moduleTask = task;
        this.moduleWrapper = wrapper;
        this.injectionLayer = wrapper.injectionLayer();
        this.fullMethodSignatureCached = String.format(METHOD_SIGNATURE_FORMAT, method.getDeclaringClass().getCanonicalName(), method.getName());
        Reflexion reflexion = Reflexion.onBound(this.module());
        this.methodAccessor = reflexion.unreflect(method);
        this.paramTypes = InjectUtil.buildElementsForParameters(method.getParameters());
    }

    @Override
    @NonNull
    public Module module() {
        return this.moduleWrapper.module();
    }

    @Override
    @NonNull
    public ModuleWrapper moduleWrapper() {
        return this.moduleWrapper;
    }

    @Override
    @NonNull
    public ModuleTask taskInfo() {
        return this.moduleTask;
    }

    @Override
    @NonNull
    public String fullMethodSignature() {
        return this.fullMethodSignatureCached;
    }

    @Override
    public void fire() throws Throwable {
        Object[] arguments = InjectUtil.findAllInstances(this.injectionLayer, this.paramTypes);
        Result result = this.methodAccessor.invokeWithArgs(arguments);
        if (result.wasExceptional()) {
            throw result.getException();
        }
    }
}

