/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.module.Module;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import lombok.NonNull;

public class DefaultModule
implements Module {
    protected ClassLoader classLoader;
    protected ModuleWrapper moduleWrapper;
    protected ModuleConfiguration moduleConfig;

    @Override
    public void init(@NonNull ClassLoader loader, @NonNull ModuleWrapper wrapper, @NonNull ModuleConfiguration config) {
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        Preconditions.checkArgument(this.classLoader == null || this.moduleWrapper == null || this.moduleConfig == null, "Cannot call init twice on a module wrapper");
        this.classLoader = loader;
        this.moduleWrapper = wrapper;
        this.moduleConfig = config;
    }

    @Override
    @NonNull
    public ModuleWrapper moduleWrapper() {
        return this.moduleWrapper;
    }

    @Override
    @NonNull
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    @NonNull
    public ModuleConfiguration moduleConfig() {
        return this.moduleConfig;
    }
}

