/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.inject;

import dev.derklaro.aerogel.Injector;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class InjectionLayerRegistry {
    private final Collection<Tuple2<Object, InjectionLayer<? extends Injector>>> knownLayers = new ConcurrentLinkedQueue<Tuple2<Object, InjectionLayer<? extends Injector>>>();

    InjectionLayerRegistry() {
    }

    public void registerLayer(@NonNull InjectionLayer<? extends Injector> layer, Object ... hints) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (hints == null) {
            throw new NullPointerException("hints is marked non-null but is null");
        }
        for (Object hint : hints) {
            this.knownLayers.add(new Tuple2<Object, InjectionLayer<? extends Injector>>(hint, layer));
        }
    }

    public void unregisterLayer(@NonNull InjectionLayer<?> layer) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        Iterator<Tuple2<Object, InjectionLayer<? extends Injector>>> iterator = this.knownLayers.iterator();
        while (iterator.hasNext()) {
            InjectionLayer<? extends Injector> registeredLayer = iterator.next().second();
            if (registeredLayer != layer) continue;
            iterator.remove();
        }
    }

    @Nullable
    public InjectionLayer<? extends Injector> findByHint(@Nullable Object hint) {
        for (Tuple2<Object, InjectionLayer<? extends Injector>> knownLayer : this.knownLayers) {
            if (knownLayer.first() != hint) continue;
            return knownLayer.second();
        }
        return null;
    }
}

